package com.trustingsocial.apisdk.data;

import com.google.gson.annotations.SerializedName;

import java.util.List;

public class TVClientSettings {
    @SerializedName("country")
    private String country;

    @SerializedName("card_types")
    private List<TVCardType> cardTypes;

    @SerializedName("settings")
    private Settings settings;

    public String getCountry() {
        return country;
    }

    public List<TVCardType> getCardTypes() {
        return cardTypes;
    }

    public Settings getSettings() {
        return settings;
    }

    public enum TVScanQrSetting {
        NONE("none"),
        SEPARATE_STEP("separate_step"),
        WITH_CARD("with_card");

        public final String name;

        TVScanQrSetting(String name) {
            this.name = name;
        }

        public static TVScanQrSetting fromName(String name) {
            if (name == null) return null;
            for (TVScanQrSetting item : TVScanQrSetting.values()) {
                if (item.name.equals(name) || item.name.equals(name.toLowerCase())) {
                    return item;
                }
            }
            return null;
        }
    }

    public class Settings {
        @SerializedName("scan_qr")
        private String scanQr;

        @SerializedName("liveness_modes")
        private List<TVLivenessOption> livenessOptions;

        @SerializedName("selfie_camera_options")
        private List<TVSelfieOption> selfieOptions;

        @SerializedName("selfie_enable_detect_multiple_face")
        private boolean enableMultipleFaceDetection;

        @SerializedName("enable_verify_portrait_sanity")
        private boolean enableSelfieSanityChecking;

        @SerializedName("enable_verify_id_card_sanity")
        private boolean enableIDSanityChecking;

        @SerializedName("enable_detect_id_card_tampering")
        private boolean enableDetectIdCardTampering;

        @SerializedName("zoom_issue_devices")
        private List<String> zoomIssueDevices;

        public TVScanQrSetting getScanQr() {
            return TVScanQrSetting.fromName(scanQr);
        }

        public List<TVLivenessOption> getLivenessOptions() {
            return livenessOptions;
        }

        public List<TVSelfieOption> getSelfieOptions() {
            return selfieOptions;
        }

        public boolean isEnableMultipleFaceDetection() {
            return enableMultipleFaceDetection;
        }

        public boolean isEnableSelfieSanityChecking() {
            return enableSelfieSanityChecking;
        }

        public boolean isEnableIDSanityChecking() {
            return enableIDSanityChecking;
        }

        public boolean isEnableDetectIdCardTampering() {
            return enableDetectIdCardTampering;
        }

        public List<String> getZoomIssueDevices() {
            return zoomIssueDevices;
        }
    }

    public enum TVLivenessOption {
        @SerializedName("passive")
        PASSIVE,
        @SerializedName("active")
        ACTIVE,
        @SerializedName("hybrid")
        HYBRID;
    }

    public enum TVSelfieOption {
        @SerializedName("back")
        BACK,
        @SerializedName("front")
        FRONT;
    }
}