package com.trustingsocial.apisdk;

import java.util.ArrayList;
import java.util.List;

import okhttp3.Call;

public class TVApi {
    public static String ACCESS_KEY_ID = "com.trustvision.accessKeyId";
    public static String ACCESS_KEY_SECRET = "com.trustvision.accessKeySecret";

    private static ApiService sApiService;
    private static IDeviceInfo sDeviceInfo;
    static List<Call> sApiCalls = new ArrayList<>();
    private static String sTransactionId;
    private static String sChannelId;


    public static void init(IAuthorizationProvider provider) {
        if (sApiService == null) {
            sApiService = new ApiServiceImpl(BuildConfig.TV_BASE_URL, provider);
        }
    }

    public static void init(String endpoint, IAuthorizationProvider provider) {
        if (sApiService == null) {
            if (endpoint == null) {
                sApiService = new ApiServiceImpl(BuildConfig.TV_BASE_URL, provider);
            } else {
                sApiService = new ApiServiceImpl(endpoint, provider);
            }
        }
    }

    public static ApiService getInstance() {
        if (sApiService == null) {
            throw new IllegalStateException("Instance was not initialized");
        }
        return sApiService;
    }

    public static void setDeviceInfo(IDeviceInfo deviceInfo) {
        sDeviceInfo = deviceInfo;
    }

    public static IDeviceInfo getDeviceInfo() {
        return sDeviceInfo;
    }

    public static String getTransactionId() {
        return sTransactionId;
    }

    public static String getChannelId() {
        return sChannelId;
    }

    public static void setTransactionId(String transactionId) {
        TVApi.sTransactionId = transactionId;
    }

    public static void setChannelId(String channelId) {
        TVApi.sChannelId = channelId;
    }

    public static void clearRequest() {
        for (Call call : sApiCalls) {
            call.cancel();
        }
        sApiCalls.clear();
    }

    public static void reset() {
        sApiService = null;
    }
}
