package com.trustingsocial.apisdk;

import com.trustingsocial.apisdk.data.TVCallback;
import com.trustingsocial.apisdk.data.TVCardInfoRequest;
import com.trustingsocial.apisdk.data.TVCardInfoResponse;
import com.trustingsocial.apisdk.data.TVClientSettings;
import com.trustingsocial.apisdk.data.TVCompareFaceResponse;
import com.trustingsocial.apisdk.data.TVIDSanityResponse;
import com.trustingsocial.apisdk.data.TVIdTamperingResponse;
import com.trustingsocial.apisdk.data.TVPollingCallback;
import com.trustingsocial.apisdk.data.TVPollingResponse;
import com.trustingsocial.apisdk.data.TVSelfieSanityResponse;
import com.trustingsocial.apisdk.data.TVSyncCardInfoRequest;
import com.trustingsocial.apisdk.data.TVSyncImage;
import com.trustingsocial.apisdk.data.TVTransaction;
import com.trustingsocial.apisdk.data.TVUploadImageResponse;
import com.trustingsocial.apisdk.data.TVVerifyLivenessResponse;

import java.util.List;
import java.util.Map;


public interface ApiService {
    void uploadImage(byte[] image, String label, Map<String, String> metadata, TVCallback<TVUploadImageResponse> callback);

    void compareFaces(String image1Id, String image2Id, TVCallback<TVPollingResponse> callback);

    void checkCompareFaces(String requestId, TVCallback<TVCompareFaceResponse> callback);

    void pollCompareFaces(String image1Id, String image2Id, TVPollingCallback<TVCompareFaceResponse> callback);

    void readIdCardInfo(TVCardInfoRequest readIdCardInfoRequest, TVCallback<TVPollingResponse> callback);

    void checkReadIdCardInfo(String requestId, TVCallback<TVCardInfoResponse> callback);

    void pollReadIdCardInfo(TVCardInfoRequest readIdCardInfoRequest, TVPollingCallback<TVCardInfoResponse> callback);

    void verifyLiveness(List<String> imageIds, TVCallback<TVPollingResponse> callback);

    void checkVerifyLiveness(String requestId, TVCallback<TVVerifyLivenessResponse> callback);

    void pollVerifyLiveness(List<String> imageIds, TVPollingCallback<TVVerifyLivenessResponse> callback);

    void getClientSettings(TVCallback<TVClientSettings> callback);

    void verifySelfieSanity(String imageId, TVPollingCallback<TVSelfieSanityResponse> callback);

    void verifyIDSanity(String imageId, TVPollingCallback<TVSelfieSanityResponse> callback);

    void syncVerifyLiveness(List<TVSyncImage> images, List<String> gestures, TVCallback<TVVerifyLivenessResponse> callback);

    void syncCompareFaces(TVSyncImage image1, TVSyncImage image2, TVCallback<TVCompareFaceResponse> callback);

    void syncVerifyIDSanity(TVSyncCardInfoRequest cardInfoRequest, TVCallback<TVIDSanityResponse> callback);

    void syncVerifySelfieSanity(TVSyncImage image, TVCallback<TVSelfieSanityResponse> callback);

    void syncReadIdCardInfo(TVSyncCardInfoRequest image, TVCallback<TVCardInfoResponse> callback);

    void syncDetectIdTampering(TVSyncImage image1, TVSyncImage image2, TVCallback<TVIdTamperingResponse> callback);

    void startTransaction(String refId, String channelName, TVCallback<TVTransaction> callback);

    void endTransaction(String transactionId, TVCallback<TVTransaction> callback);

    void downloadImage(String imageId, TVCallback<byte[]> callback);
}