/*
 * Decompiled with CFR 0.152.
 */
package com.trustingsocial.apisdk.data;

import com.google.gson.annotations.SerializedName;
import com.trustingsocial.apisdk.data.TVCardType;
import java.util.List;

public class TVClientSettings {
    @SerializedName(value="country")
    private String country;
    @SerializedName(value="card_types")
    private List<TVCardType> cardTypes;
    @SerializedName(value="settings")
    private Settings settings;

    public String getCountry() {
        return this.country;
    }

    public List<TVCardType> getCardTypes() {
        return this.cardTypes;
    }

    public Settings getSettings() {
        return this.settings;
    }

    public static enum TVSelfieOption {
        BACK,
        FRONT;

    }

    public static enum TVLivenessOption {
        PASSIVE,
        ACTIVE,
        HYBRID;

    }

    public class Settings {
        @SerializedName(value="scan_qr")
        private String scanQr;
        @SerializedName(value="liveness_modes")
        private List<TVLivenessOption> livenessOptions;
        @SerializedName(value="selfie_camera_options")
        private List<TVSelfieOption> selfieOptions;
        @SerializedName(value="selfie_enable_detect_multiple_face")
        private boolean enableMultipleFaceDetection;
        @SerializedName(value="enable_verify_portrait_sanity")
        private boolean enableSelfieSanityChecking;
        @SerializedName(value="enable_verify_id_card_sanity")
        private boolean enableIDSanityChecking;
        @SerializedName(value="enable_detect_id_card_tampering")
        private boolean enableDetectIdCardTampering;
        @SerializedName(value="zoom_issue_devices")
        private List<String> zoomIssueDevices;

        public TVScanQrSetting getScanQr() {
            return TVScanQrSetting.fromName(this.scanQr);
        }

        public List<TVLivenessOption> getLivenessOptions() {
            return this.livenessOptions;
        }

        public List<TVSelfieOption> getSelfieOptions() {
            return this.selfieOptions;
        }

        public boolean isEnableMultipleFaceDetection() {
            return this.enableMultipleFaceDetection;
        }

        public boolean isEnableSelfieSanityChecking() {
            return this.enableSelfieSanityChecking;
        }

        public boolean isEnableIDSanityChecking() {
            return this.enableIDSanityChecking;
        }

        public boolean isEnableDetectIdCardTampering() {
            return this.enableDetectIdCardTampering;
        }

        public List<String> getZoomIssueDevices() {
            return this.zoomIssueDevices;
        }
    }

    public static enum TVScanQrSetting {
        NONE("none"),
        SEPARATE_STEP("separate_step"),
        WITH_CARD("with_card");

        public final String name;

        private TVScanQrSetting(String name) {
            this.name = name;
        }

        public static TVScanQrSetting fromName(String name) {
            if (name == null) {
                return null;
            }
            for (TVScanQrSetting item : TVScanQrSetting.values()) {
                if (!item.name.equals(name) && !item.name.equals(name.toLowerCase())) continue;
                return item;
            }
            return null;
        }
    }
}

