package com.trustingsocial.apisdk.data;

import com.google.gson.annotations.SerializedName;
import com.trustingsocial.apisdk.utils.Utils;

public abstract class TVPollingStatusResponse {
    @SerializedName("status")
    private String status = null;

    @SerializedName("request_id")
    private String requestId;

    public Status getStatus() {
        return Status.fromName(this.status);
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public String getRequestId() {
        return requestId;
    }

    public void setRequestId(String requestId) {
        this.requestId = requestId;
    }

    public enum Status {
        PROCESSING("processing"),
        SUCCESS("success"),
        FAILURE("failure");

        public final String name;

        Status(String name) {
            this.name = name;
        }

        private static Status fromName(String name) {
            if (Utils.isEmptyString(name)) return null;

            for (Status status : Status.values()) {
                if (status.name.equals(name)) return status;
            }

            return null;
        }
    }
}
