package com.trustingsocial.apisdk.data;

import com.google.gson.annotations.SerializedName;

import java.util.List;

public class TVCardInfoResponse extends TVPollingStatusResponse {

    @SerializedName("image1")
    private Image image1;
    @SerializedName("image2")
    private Image image2;
    @SerializedName("card_information")
    private List<Info> cardInformation;

    public Image getImage1() {
        return image1;
    }

    public Image getImage2() {
        return image2;
    }

    public List<Info> getCardInformation() {
        return cardInformation;
    }

    /**
     * Image
     */
    public class Image extends TVImage {
        @SerializedName("qr")
        private QR qr;
        @SerializedName("ocr")
        private Ocr ocr;

        public QR getQr() {
            return qr;
        }

        public Ocr getOcr() {
            return ocr;
        }
    }

    /**
     * Class
     */
    public class Info {
        @SerializedName("field")
        private String field;
        @SerializedName("value")
        private String value;

        public String getField() {
            return field;
        }

        public String getValue() {
            return value;
        }
    }

    /**
     * Ocr
     */
    public class QR {
        @SerializedName("raw")
        private String raw;
        @SerializedName("parsed")
        private List<Info> value;

        public String getRaw() {
            return raw;
        }

        public List<Info> getValue() {
            return value;
        }
    }

    /**
     * Ocr
     */
    public class Ocr {
        @SerializedName("parsed")
        private List<Info> value;
        @SerializedName("bounding_box")
        private List<OcrRaw> raw;

        public List<Info> getValue() {
            return value;
        }

        public List<OcrRaw> getRaw() {
            return raw;
        }
    }

    /**
     * Ocr Raw
     */
    public class OcrRaw {
        @SerializedName("group")
        private String group;
        @SerializedName("label")
        private String label;
        @SerializedName("line")
        private String line;
        @SerializedName("text")
        private String text;
        @SerializedName("bounding_box")
        private List<Point> boundingBox;

        public String getText() {
            return text;
        }

        public List<Point> getBoundingBox() {
            return boundingBox;
        }

        public void setGroup(String group) {
            this.group = group;
        }

        public String getLabel() {
            return label;
        }

        public String getLine() {
            return line;
        }
    }

    /**
     * Point
     */
    public class Point {
        @SerializedName("x")
        private int x;
        @SerializedName("y")
        private int y;

        public int getX() {
            return x;
        }

        public int getY() {
            return y;
        }
    }
}


