/*
 * Decompiled with CFR 0.152.
 */
package com.trustingsocial.apisdk.data;

import com.google.gson.annotations.SerializedName;

public class TVCardType {
    @SerializedName(value="code")
    private String code;
    @SerializedName(value="name")
    private String name;
    @SerializedName(value="orientation")
    private String orientation;
    @SerializedName(value="has_back_side")
    private boolean hasBackSide;
    @SerializedName(value="front_qr")
    private TVQrSide frontQr;
    @SerializedName(value="back_qr")
    private TVQrSide backQr;

    public String getCode() {
        return this.code;
    }

    public String getName() {
        return this.name;
    }

    public TVCardOrientation getOrientation() {
        return TVCardOrientation.getByName(this.orientation);
    }

    public boolean isHasBackSide() {
        return this.hasBackSide;
    }

    public TVQrSide getFrontQr() {
        return this.frontQr;
    }

    public TVQrSide getBackQr() {
        return this.backQr;
    }

    public class TVQrSide {
        @SerializedName(value="exist")
        private boolean exist;
        @SerializedName(value="type")
        private String type;
        @SerializedName(value="width_height_ratio")
        private float widthHeightRatio;

        public boolean isExist() {
            return this.exist;
        }

        public TVQrType getType() {
            return TVQrType.getByName(this.type);
        }

        public float getWidthHeightRatio() {
            return this.widthHeightRatio;
        }
    }

    public static enum TVQrType {
        QR_CODE,
        BAR_CODE;


        static TVQrType getByName(String name) {
            try {
                return TVQrType.valueOf(name.toUpperCase());
            }
            catch (Exception ex) {
                return null;
            }
        }
    }

    public static enum TVCardOrientation {
        VERTICAL,
        HORIZONTAL;


        static TVCardOrientation getByName(String name) {
            try {
                return TVCardOrientation.valueOf(name.toUpperCase());
            }
            catch (Exception ex) {
                return null;
            }
        }
    }
}

