/*
 * Decompiled with CFR 0.152.
 */
package com.trustingsocial.apisdk;

import android.os.Handler;
import android.os.HandlerThread;
import android.util.Log;
import com.trustingsocial.apisdk.ApiServiceImpl;
import com.trustingsocial.apisdk.IAuthorizationProvider;
import com.trustingsocial.apisdk.IDeviceInfo;
import com.trustingsocial.apisdk.TVApi;
import com.trustingsocial.apisdk.data.TVApiError;
import com.trustingsocial.apisdk.data.TVAuthorization;
import com.trustingsocial.apisdk.data.TVCallback;
import com.trustingsocial.apisdk.data.TVPollingCallback;
import com.trustingsocial.apisdk.data.TVPollingStatusResponse;
import com.trustingsocial.apisdk.data.TVResponseData;
import com.trustingsocial.apisdk.utils.DecryptiontInterceptor;
import com.trustingsocial.apisdk.utils.GsonUtils;
import com.trustingsocial.apisdk.utils.Utils;
import java.io.IOException;
import java.security.SecureRandom;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import okhttp3.Call;
import okhttp3.Callback;
import okhttp3.Interceptor;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import org.json.JSONObject;

class ApiServiceHelper {
    private static final String TAG = ApiServiceImpl.class.getSimpleName();
    private static int PULLING_TIMEOUT = 30000;
    private static Integer PULLING_THRESHOLD = 1000;
    private final OkHttpClient mClient;
    private final String baseUrl;
    private HashMap<String, Integer> pullingMap = new HashMap();
    private IAuthorizationProvider authorizationProvider;

    ApiServiceHelper(String baseUrl, IAuthorizationProvider authorizationProvider) {
        this.baseUrl = baseUrl;
        this.authorizationProvider = authorizationProvider;
        try {
            X509TrustManager trustManager = new X509TrustManager(){

                @Override
                public void checkClientTrusted(X509Certificate[] chain, String authType) throws CertificateException {
                }

                @Override
                public void checkServerTrusted(X509Certificate[] chain, String authType) throws CertificateException {
                }

                @Override
                public X509Certificate[] getAcceptedIssuers() {
                    return new X509Certificate[0];
                }
            };
            TrustManager[] trustAllCerts = new TrustManager[]{trustManager};
            SSLContext sslContext = SSLContext.getInstance("SSL");
            sslContext.init(null, trustAllCerts, new SecureRandom());
            SSLSocketFactory sslSocketFactory = sslContext.getSocketFactory();
            OkHttpClient.Builder builder = new OkHttpClient.Builder();
            builder.sslSocketFactory(sslSocketFactory, trustManager);
            builder.writeTimeout(60L, TimeUnit.SECONDS);
            builder.readTimeout(60L, TimeUnit.SECONDS);
            builder.hostnameVerifier(new HostnameVerifier(){

                @Override
                public boolean verify(String hostname, SSLSession session) {
                    return true;
                }
            });
            builder.addInterceptor((Interceptor)new DecryptiontInterceptor(authorizationProvider.getSecretKey()));
            this.mClient = builder.build();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    <T> void requestJSON(String path, Object bodyData, TVCallback<T> callback, Class<T> type) {
        RequestBody body = RequestBody.create((MediaType)Utils.JSON, (String)GsonUtils.toJson(bodyData));
        Log.e((String)TAG, (String)("body: " + GsonUtils.toJson(bodyData)));
        this.request("POST", path, body, callback, type);
    }

    <T> void requestJSON(String path, Map<String, Object> params, TVCallback<T> callback, Class<T> type) {
        JSONObject parameter = new JSONObject(params);
        RequestBody body = RequestBody.create((MediaType)Utils.JSON, (String)parameter.toString());
        Log.e((String)TAG, (String)("body: " + parameter.toString()));
        this.request("POST", path, body, callback, type);
    }

    <T> void requestGet(String path, TVCallback<T> callback, Class<T> type) {
        this.request("GET", path, null, callback, type);
    }

    <T> void request(final String method, final String path, final RequestBody requestBody, final TVCallback<T> callback, final Class<T> type) {
        this.authorizationProvider.getAuthorization(method, path, new TVCallback<TVAuthorization>(){

            @Override
            public void onSuccess(TVAuthorization authorization) {
                TVApi.sApiCalls.add(ApiServiceHelper.this.doRequest(method, path, requestBody, authorization, callback, type));
            }

            @Override
            public void onError(List<TVApiError> errors) {
                callback.onError(errors);
            }
        });
    }

    private <T> Call doRequest(String method, String path, RequestBody requestBody, TVAuthorization authorization, final TVCallback<T> callback, final Class<T> type) {
        try {
            Request request = this.buildRequest(method, path, requestBody, authorization);
            Call call = this.mClient.newCall(request);
            call.enqueue(new Callback(){

                public void onFailure(Call call, IOException e) {
                    Log.e((String)TAG, (String)"onFailure");
                    callback.onError(Collections.singletonList(TVApiError.networkError()));
                }

                public void onResponse(Call call, Response response) {
                    Log.e((String)TAG, (String)("onResponse: " + call.request().url()));
                    try {
                        if (type == byte[].class) {
                            ApiServiceHelper.this.handleDownloadResult(response, callback);
                        } else {
                            ApiServiceHelper.this.handleResponse(response, callback, type);
                        }
                    }
                    catch (Exception ex) {
                        callback.onError(Collections.singletonList(TVApiError.internalError()));
                        Log.e((String)TAG, (String)ex.getMessage(), (Throwable)ex);
                    }
                }
            });
            return call;
        }
        catch (Exception ex) {
            callback.onError(Collections.singletonList(new TVApiError("internal_error", ex.getMessage())));
            return null;
        }
    }

    private void handleDownloadResult(Response response, TVCallback<byte[]> callback) throws Exception {
        if (response.isSuccessful()) {
            byte[] byteRes = response.body().bytes();
            callback.onSuccess(byteRes);
        } else {
            String res = response.body().string().trim();
            Log.e((String)TAG, (String)("response: " + res));
            TVResponseData responseData = GsonUtils.fromJson(res, TVResponseData.class);
            callback.onError(responseData.getErrors());
        }
    }

    private <T> void handleResponse(Response response, TVCallback<T> callback, Class<T> type) throws Exception {
        String res = response.body().string().trim();
        Log.e((String)TAG, (String)("response: " + res));
        TVResponseData responseData = (TVResponseData)GsonUtils.fromJson(res, GsonUtils.getType(TVResponseData.class, type));
        if (response.isSuccessful() && responseData.getErrors() == null && responseData.getData() != null) {
            callback.onSuccess(responseData.getData());
        } else {
            callback.onError(responseData.getErrors());
            Log.e((String)TAG, (String)GsonUtils.getInstance().toJson((Object)responseData));
        }
    }

    private Request buildRequest(String method, String path, RequestBody requestBody, TVAuthorization authorization) {
        String channelId;
        String transactionId;
        String signature = "TV " + authorization.getApiKeyId() + ":" + authorization.getSignature();
        Log.e((String)TAG, (String)("Authorization: " + signature));
        Log.e((String)TAG, (String)("Timestamp: " + authorization.getTimestamp()));
        Request.Builder requestBuilder = new Request.Builder().url(this.baseUrl + path).method(method, requestBody).addHeader("Authorization", signature).addHeader("X-TV-Timestamp", authorization.getTimestamp());
        IDeviceInfo deviceInfo = TVApi.getDeviceInfo();
        if (deviceInfo != null) {
            requestBuilder.addHeader("X-TV-OS-Platform", deviceInfo.getPlatform());
            requestBuilder.addHeader("X-TV-OS-Version", deviceInfo.getOSVersion());
            requestBuilder.addHeader("X-TV-SDK-Version", deviceInfo.getSDKVersion());
            requestBuilder.addHeader("X-TV-Device-Model", deviceInfo.getDeviceModel());
        }
        if (!Utils.isEmptyString(transactionId = TVApi.getTransactionId())) {
            requestBuilder.addHeader("X-TV-Transaction", transactionId);
        }
        if (!Utils.isEmptyString(channelId = TVApi.getChannelId())) {
            requestBuilder.addHeader("X-TV-Channel", channelId);
        }
        return requestBuilder.build();
    }

    <T extends TVPollingStatusResponse> void doPolling(final String requestId, final String apiPath, final TVPollingCallback<T> callback, final Class<T> type) {
        callback.onReceiveRequestId(requestId);
        HandlerThread handlerThread = new HandlerThread("Pooling_thread");
        handlerThread.start();
        final Handler handler = new Handler(handlerThread.getLooper());
        this.pullingMap.put(requestId, 0);
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                final 5 mRunnable = this;
                ApiServiceHelper.this.requestGet(apiPath + "/" + requestId, new TVCallback<T>(){

                    @Override
                    public void onSuccess(T data) {
                        if (((TVPollingStatusResponse)data).getStatus() == TVPollingStatusResponse.Status.PROCESSING) {
                            Integer currentPullTime = (Integer)ApiServiceHelper.this.pullingMap.get(requestId);
                            Integer newPullingTime = currentPullTime + PULLING_THRESHOLD;
                            ApiServiceHelper.this.pullingMap.put(requestId, newPullingTime);
                            if (newPullingTime < PULLING_TIMEOUT) {
                                handler.postDelayed(mRunnable, (long)PULLING_THRESHOLD.intValue());
                            } else {
                                callback.onError(Collections.singletonList(TVApiError.timeoutError()));
                            }
                        } else if (((TVPollingStatusResponse)data).getStatus() == TVPollingStatusResponse.Status.FAILURE) {
                            callback.onError(Collections.singletonList(TVApiError.timeoutError()));
                        } else {
                            callback.onSuccess(data);
                        }
                    }

                    @Override
                    public void onError(List<TVApiError> errors) {
                        callback.onError(errors);
                    }
                }, type);
            }
        };
        handler.postDelayed(runnable, (long)PULLING_THRESHOLD.intValue());
    }
}

