package com.trustingsocial.apisdk.utils;

import com.trustingsocial.apisdk.TVApi;
import com.trustingsocial.apisdk.data.TVEncryptedResponse;

import java.io.IOException;

import okhttp3.Interceptor;
import okhttp3.Response;
import okhttp3.ResponseBody;


public class DecryptiontInterceptor implements Interceptor {
    public static final String HEADER_ENCRYPTED = "X-Tv-Encrypted";
    private String secretKey;

    public DecryptiontInterceptor(String key) {
        this.secretKey = key;
    }

    @Override
    public Response intercept(Chain chain) throws IOException {
        Response originalResponse = chain.proceed(chain.request());
        boolean isEncrypted = Boolean.parseBoolean(originalResponse.header(HEADER_ENCRYPTED, "false"));
        if (!isEncrypted) {
            return originalResponse;
        }
        String encryptedData = originalResponse.body().string().trim();
        TVEncryptedResponse encryptedResponse = GsonUtils.fromJson(encryptedData, TVEncryptedResponse.class);
        String jsonString = encryptedResponse.getData();
        String transactionId = TVApi.getTransactionId();
        if (Utils.isEmptyString(secretKey) || secretKey.length() < 16 || Utils.isEmptyString(transactionId)) {
            return originalResponse.newBuilder()
                    .code(500)
                    .build();
        }
        String finalKey = secretKey.substring(0, 16) + TVApi.getTransactionId().substring(0, 16);
        String decryptedString = Utils.decrypt(jsonString, finalKey);
        ResponseBody decrypedBody =  ResponseBody.create(Utils.JSON, decryptedString);
        return originalResponse.newBuilder()
                .body(decrypedBody)
                .build();
    }
}
