package com.trustingsocial.apisdk.data;

import com.google.gson.annotations.SerializedName;

import java.util.List;

public class TVCompareFaceResponse extends TVPollingStatusResponse {
    @SerializedName("image1")
    private Image image1;
    @SerializedName("image2")
    private Image image2;
    @SerializedName("compare_faces")
    private List<CompareFaces> compareFaces;

    public Image getImage1() {
        return image1;
    }

    public Image getImage2() {
        return image2;
    }

    public List<CompareFaces> getCompareFaces() {
        return compareFaces;
    }

    public enum MatchResult {
        MATCHED("matched"),
        UNMATCHED("unmatched"),
        UNSURE("unsure");

        public final String name;

        MatchResult(String name) {
            this.name = name;
        }

        public static MatchResult fromName(String name) {
            if (name == null) return null;
            for (MatchResult item : MatchResult.values()) {
                if (item.name.equals(name) || item.name.equals(name.toLowerCase())) {
                    return item;
                }
            }
            return null;
        }
    }

    /**
     * Image
     */
    public class Image extends TVImage {
        @SerializedName("Faces")
        private List<Face> Faces;

        public List<Face> getFaces() {
            return Faces;
        }
    }

    /**
     * CompareFaces
     */
    public class CompareFaces {
        @SerializedName("score")
        private float score;
        @SerializedName("result")
        private String result;
        @SerializedName("face1_id")
        private String face1Id;
        @SerializedName("face2_id")
        private String face2Id;

        public float getScore() {
            return score;
        }

        public MatchResult getResult() {
            return MatchResult.fromName(result);
        }

        public String getFace1Id() {
            return face1Id;
        }

        public String getFace2Id() {
            return face2Id;
        }
    }

    /**
     * Face
     */
    public class Face {
        @SerializedName("id")
        private String id;

        @SerializedName("bounding_box")
        private BoundingBox boundingBox;

        public BoundingBox getBoundingBox() {
            return boundingBox;
        }

        public String getId() {
            return id;
        }
    }

    /**
     * BoundingBox
     */
    public class BoundingBox {
        @SerializedName("top")
        private float top;
        @SerializedName("right")
        private float right;
        @SerializedName("bottom")
        private float bottom;
        @SerializedName("left")
        private float left;
        @SerializedName("angle")
        private float angle;

        public float getTop() {
            return top;
        }

        public float getRight() {
            return right;
        }

        public float getBottom() {
            return bottom;
        }

        public float getLeft() {
            return left;
        }

        public float getAngle() {
            return angle;
        }
    }
}
