package com.trustingsocial.apisdk.data;

import com.google.gson.annotations.SerializedName;

public class TVCardType {
    @SerializedName("code")
    private String code;
    @SerializedName("name")
    private String name;
    @SerializedName("orientation")
    private String orientation;
    @SerializedName("has_back_side")
    private boolean hasBackSide;
    @SerializedName("front_qr")
    private TVQrSide frontQr;
    @SerializedName("back_qr")
    private TVQrSide backQr;

    public String getCode() {
        return code;
    }

    public String getName() {
        return name;
    }

    public TVCardOrientation getOrientation() {
        return TVCardOrientation.getByName(orientation);
    }

    public boolean isHasBackSide() {
        return hasBackSide;
    }

    public TVQrSide getFrontQr() {
        return frontQr;
    }

    public TVQrSide getBackQr() {
        return backQr;
    }

    public enum TVCardOrientation {
        VERTICAL,
        HORIZONTAL;

        static TVCardOrientation getByName(String name) {
            try {
                return TVCardOrientation.valueOf(name.toUpperCase());
            } catch (Exception ex) {
                return null;
            }
        }
    }

    public enum TVQrType {
        QR_CODE,
        BAR_CODE;

        static TVQrType getByName(String name) {
            try {
                return TVQrType.valueOf(name.toUpperCase());
            } catch (Exception ex) {
                return null;
            }
        }
    }

    public class TVQrSide {
        @SerializedName("exist")
        private boolean exist;
        @SerializedName("type")
        private String type;
        @SerializedName("width_height_ratio")
        private float widthHeightRatio;

        public boolean isExist() {
            return exist;
        }

        public TVQrType getType() {
            return TVQrType.getByName(type);
        }

        public float getWidthHeightRatio() {
            return widthHeightRatio;
        }
    }
}
