/*
 * Decompiled with CFR 0.152.
 */
package com.trustdecision.sdk.liveness.model.config;

import android.os.Parcel;
import android.os.Parcelable;
import android.text.TextUtils;
import com.trustdecision.sdk.liveness.model.STException;
import com.trustdecision.sdk.liveness.model.config.AbsLoadLLVM;
import com.trustdecision.sdk.liveness.model.config.IConfig;

public class ModelsConfig
implements IConfig {
    public static final Parcelable.Creator<ModelsConfig> CREATOR = new Parcelable.Creator<ModelsConfig>(){

        public ModelsConfig createFromParcel(Parcel parcel) {
            return new ModelsConfig(parcel);
        }

        public ModelsConfig[] newArray(int n) {
            return new ModelsConfig[n];
        }
    };
    private String hunterModelPath;
    private String alignModelPath;
    private String headPoseModelPath;
    private String pageantModelPath;
    private String eyeStateModelPath;

    private ModelsConfig() {
    }

    private ModelsConfig(Builder builder) {
        this.hunterModelPath = builder.hunterModelPath;
        this.alignModelPath = builder.alignModelPath;
        this.headPoseModelPath = builder.headPoseModelPath;
        this.pageantModelPath = builder.pageantModelPath;
        this.eyeStateModelPath = builder.eyeStateModelPath;
    }

    protected ModelsConfig(Parcel parcel) {
        this.hunterModelPath = parcel.readString();
        this.alignModelPath = parcel.readString();
        this.headPoseModelPath = parcel.readString();
        this.pageantModelPath = parcel.readString();
        this.eyeStateModelPath = parcel.readString();
    }

    @Override
    public boolean check() throws STException {
        if (!TextUtils.isEmpty((CharSequence)this.hunterModelPath)) {
            if (!TextUtils.isEmpty((CharSequence)this.alignModelPath)) {
                if (!TextUtils.isEmpty((CharSequence)this.headPoseModelPath)) {
                    if (!TextUtils.isEmpty((CharSequence)this.pageantModelPath)) {
                        if (!TextUtils.isEmpty((CharSequence)this.eyeStateModelPath)) {
                            return true;
                        }
                        throw new STException("eyeStateModelPath can not be null", 1100);
                    }
                    throw new STException("pageantModelPath can not be null", 1100);
                }
                throw new STException("headPoseModelPath can not be null", 1100);
            }
            throw new STException("alignModelPath can not be null", 1100);
        }
        throw new STException("hunterModelPath can not be null", 1100);
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel parcel, int n) {
        parcel.writeString(this.hunterModelPath);
        parcel.writeString(this.alignModelPath);
        parcel.writeString(this.headPoseModelPath);
        parcel.writeString(this.pageantModelPath);
        parcel.writeString(this.eyeStateModelPath);
    }

    public void readFromParcel(Parcel parcel) {
        this.hunterModelPath = parcel.readString();
        this.alignModelPath = parcel.readString();
        this.headPoseModelPath = parcel.readString();
        this.pageantModelPath = parcel.readString();
        this.eyeStateModelPath = parcel.readString();
    }

    public static final class Builder
    extends AbsLoadLLVM {
        private String hunterModelPath;
        private String alignModelPath;
        private String headPoseModelPath;
        private String pageantModelPath;
        private String eyeStateModelPath;

        public Builder setHunterModelPath(String string2) {
            this.hunterModelPath = string2;
            return this;
        }

        public Builder setAlignModelPath(String string2) {
            this.alignModelPath = string2;
            return this;
        }

        public Builder setHeadPoseModelPath(String string2) {
            this.headPoseModelPath = string2;
            return this;
        }

        public Builder setPageantModelPath(String string2) {
            this.pageantModelPath = string2;
            return this;
        }

        public Builder setEyeStateModelPath(String string2) {
            this.eyeStateModelPath = string2;
            return this;
        }

        public ModelsConfig build() {
            return new ModelsConfig(this);
        }
    }
}

