/*
 * Decompiled with CFR 0.152.
 */
package com.trustdecision.sdk.liveness.model.config;

import android.os.Parcel;
import android.os.Parcelable;
import android.text.TextUtils;
import com.trustdecision.sdk.liveness.model.STException;
import com.trustdecision.sdk.liveness.model.config.AbsLoadLLVM;
import com.trustdecision.sdk.liveness.model.config.IConfig;

public class ModelsConfig
implements IConfig {
    public static final Parcelable.Creator<ModelsConfig> CREATOR;
    private String hunterModelPath;
    private String alignModelPath;
    private String headPoseModelPath;
    private String pageantModelPath;
    private String eyeStateModelPath;

    private ModelsConfig() {
    }

    private ModelsConfig(Builder builder) {
        this.hunterModelPath = builder.hunterModelPath;
        this.alignModelPath = builder.alignModelPath;
        this.headPoseModelPath = builder.headPoseModelPath;
        this.pageantModelPath = builder.pageantModelPath;
        this.eyeStateModelPath = builder.eyeStateModelPath;
    }

    protected ModelsConfig(Parcel parcel) {
        this.hunterModelPath = parcel.readString();
        this.alignModelPath = parcel.readString();
        this.headPoseModelPath = parcel.readString();
        this.pageantModelPath = parcel.readString();
        this.eyeStateModelPath = parcel.readString();
    }

    static {
        System.loadLibrary("llvmliveness");
        CREATOR = new Parcelable.Creator<ModelsConfig>(){

            public ModelsConfig createFromParcel(Parcel parcel) {
                return new ModelsConfig(parcel);
            }

            public ModelsConfig[] newArray(int n) {
                return new ModelsConfig[n];
            }
        };
    }

    @Override
    public boolean check() throws STException {
        if (!TextUtils.isEmpty((CharSequence)this.hunterModelPath)) {
            if (!TextUtils.isEmpty((CharSequence)this.alignModelPath)) {
                if (!TextUtils.isEmpty((CharSequence)this.headPoseModelPath)) {
                    if (!TextUtils.isEmpty((CharSequence)this.pageantModelPath)) {
                        if (!TextUtils.isEmpty((CharSequence)this.eyeStateModelPath)) {
                            return true;
                        }
                        throw new STException("eyeStateModelPath can not be null", 1100);
                    }
                    throw new STException("pageantModelPath can not be null", 1100);
                }
                throw new STException("headPoseModelPath can not be null", 1100);
            }
            throw new STException("alignModelPath can not be null", 1100);
        }
        throw new STException("hunterModelPath can not be null", 1100);
    }

    public native int describeContents();

    public native void writeToParcel(Parcel var1, int var2);

    public native void readFromParcel(Parcel var1);

    public static final class Builder
    extends AbsLoadLLVM {
        private String hunterModelPath;
        private String alignModelPath;
        private String headPoseModelPath;
        private String pageantModelPath;
        private String eyeStateModelPath;

        public native Builder setHunterModelPath(String var1);

        public native Builder setAlignModelPath(String var1);

        public native Builder setHeadPoseModelPath(String var1);

        public native Builder setPageantModelPath(String var1);

        public native Builder setEyeStateModelPath(String var1);

        public native ModelsConfig build();

        static {
            System.loadLibrary("llvmliveness");
        }
    }
}

