/*
 * Decompiled with CFR 0.152.
 */
package com.trustdecision.liveness.cw.libproject.sm2;

import android.text.TextUtils;
import com.trustdecision.liveness.cw.libproject.sm2.SM2;
import com.trustdecision.liveness.cw.libproject.sm2.SM2Signer;
import com.trustdecision.liveness.cw.util.Base64Util;
import com.trustdecision.liveness.cw.util.LoggerUtil;
import java.security.KeyFactory;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.Security;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.X509EncodedKeySpec;
import org.bouncycastle.crypto.CipherParameters;
import org.bouncycastle.crypto.CryptoException;
import org.bouncycastle.crypto.InvalidCipherTextException;
import org.bouncycastle.crypto.engines.SM2Engine;
import org.bouncycastle.crypto.params.ParametersWithRandom;
import org.bouncycastle.crypto.signers.DSAEncoding;
import org.bouncycastle.crypto.signers.PlainDSAEncoding;
import org.bouncycastle.jcajce.provider.asymmetric.ec.BCECPrivateKey;
import org.bouncycastle.jcajce.provider.asymmetric.util.ECUtil;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.pqc.math.linearalgebra.ByteUtils;
import org.bouncycastle.util.encoders.Base64;
import org.bouncycastle.util.encoders.Hex;

public class SM2Util {
    static final byte a = 4;
    private static final SM2Engine.Mode b = SM2Engine.Mode.C1C2C3;

    private SM2Util() {
        throw new UnsupportedOperationException("util class cant be instantiation");
    }

    public static boolean isValidPrivateKey(byte[] byArray) {
        return SM2.Instance().c(byArray);
    }

    public static byte[] getPublicKeyFromPrivateKey(byte[] byArray) {
        return SM2.Instance().b(byArray);
    }

    public static String encrypt(byte[] object, byte[] object2, byte[] byArray) {
        String string2 = "";
        if (object != null && object2 != null) {
            if (byArray != null && byArray.length != 0) {
                ParametersWithRandom parametersWithRandom;
                int n = byArray.length;
                byte[] byArray2 = new byte[n];
                int n2 = byArray.length;
                System.arraycopy(byArray, 0, byArray2, 0, n2);
                object = SM2.Instance().getPublicKeyParameters((byte[])object, (byte[])object2);
                SM2Engine sM2Engine = new SM2Engine(b);
                object2 = parametersWithRandom;
                parametersWithRandom = new ParametersWithRandom((CipherParameters)object, new SecureRandom());
                sM2Engine.init(true, (CipherParameters)object2);
                try {
                    return Base64Util.encode(ByteUtils.subArray((byte[])sM2Engine.processBlock(byArray2, 0, n), (int)1), 2);
                }
                catch (InvalidCipherTextException invalidCipherTextException) {
                    invalidCipherTextException.printStackTrace();
                    return string2;
                }
            }
            return string2;
        }
        return string2;
    }

    public static String encryptHex(String string2, byte[] byArray) {
        if (string2.length() == 130) {
            string2 = string2.substring(2);
        }
        if (!TextUtils.isEmpty((CharSequence)(string2 = SM2Util.encryptBase64(string2.substring(0, 64), string2.substring(64, 128), byArray)))) {
            return Hex.toHexString((byte[])Base64Util.decode(string2));
        }
        return null;
    }

    public static String encryptBase64(String object, String string2, byte[] byArray) {
        if (!TextUtils.isEmpty((CharSequence)object) && !TextUtils.isEmpty((CharSequence)string2)) {
            ParametersWithRandom parametersWithRandom;
            SM2Engine sM2Engine;
            object = ByteUtils.fromHexString((String)object);
            object = SM2.Instance().getPublicKeyParameters((byte[])object, ByteUtils.fromHexString((String)string2));
            String string3 = string2 = sM2Engine;
            string3(SM2Engine.Mode.C1C2C3);
            string2 = parametersWithRandom;
            parametersWithRandom = new ParametersWithRandom((CipherParameters)object, new SecureRandom());
            string3.init(true, (CipherParameters)string2);
            int n = 0;
            try {
                return Base64Util.encode(sM2Engine.processBlock(byArray, n, byArray.length), 2);
            }
            catch (InvalidCipherTextException invalidCipherTextException) {
                invalidCipherTextException.printStackTrace();
            }
        }
        return null;
    }

    public static byte[] decrypt(byte[] object, byte[] byArray) {
        if (object != null && ((byte[])object).length != 0) {
            SM2Engine sM2Engine;
            SM2Engine sM2Engine2;
            if (byArray.length == 0) {
                return new byte[0];
            }
            byArray = ByteUtils.concatenate((byte[])new byte[]{4}, (byte[])byArray);
            object = SM2.Instance().a((byte[])object);
            SM2Engine sM2Engine3 = sM2Engine2 = sM2Engine;
            sM2Engine3(b);
            sM2Engine3.init(false, (CipherParameters)object);
            int n = 0;
            try {
                return sM2Engine.processBlock(byArray, n, byArray.length);
            }
            catch (InvalidCipherTextException invalidCipherTextException) {
                invalidCipherTextException.printStackTrace();
                return new byte[0];
            }
        }
        return new byte[0];
    }

    public static byte[] sign(byte[] object, byte[] byArray) {
        SM2Signer sM2Signer;
        SM2Signer sM2Signer2;
        object = SM2.Instance().a((byte[])object);
        SM2Signer sM2Signer3 = sM2Signer2 = sM2Signer;
        sM2Signer3((DSAEncoding)new PlainDSAEncoding());
        sM2Signer3.init(true, (CipherParameters)object);
        sM2Signer.update(byArray, 0, byArray.length);
        try {
            return sM2Signer.generateSignature();
        }
        catch (CryptoException cryptoException) {
            return new byte[0];
        }
    }

    public static boolean verifySign(byte[] byArray, byte[] byArray2, byte[] byArray3) {
        return true;
    }

    public static String encryptSm2Base64Pubkey(String object, byte[] byArray) {
        SM2Engine sM2Engine;
        ParametersWithRandom parametersWithRandom;
        String string2;
        try {
            string2 = object;
            Security.addProvider((Provider)new BouncyCastleProvider());
        }
        catch (Exception exception) {
            LoggerUtil.e("\u52a0\u5bc6\u5931\u8d25{}", exception.getMessage());
            return null;
        }
        object = Base64.decode((String)string2);
        KeyFactory keyFactory = KeyFactory.getInstance("EC", (Provider)new BouncyCastleProvider());
        X509EncodedKeySpec x509EncodedKeySpec = new X509EncodedKeySpec((byte[])object);
        LoggerUtil.i("\u83b7\u53d6\u8f6c\u6362\u540e\u7684\u516c\u94a5");
        object = keyFactory.generatePublic(x509EncodedKeySpec);
        LoggerUtil.i("\u5f00\u59cb\u52a0\u5bc6");
        ParametersWithRandom parametersWithRandom2 = parametersWithRandom;
        parametersWithRandom = new ParametersWithRandom((CipherParameters)ECUtil.generatePublicKeyParameter((PublicKey)object), new SecureRandom());
        object = sM2Engine;
        byte[] byArray2 = byArray;
        byte[] byArray3 = byArray;
        Object object2 = object;
        object2();
        object2.init(true, (CipherParameters)parametersWithRandom2);
        int n = 0;
        return Base64.toBase64String((byte[])sM2Engine.processBlock(byArray3, n, byArray2.length));
    }

    public static String encryptSm2HexPubkey(String object, String string2) {
        ParametersWithRandom parametersWithRandom;
        String string3;
        try {
            string3 = object;
            Security.addProvider((Provider)new BouncyCastleProvider());
        }
        catch (Exception exception) {
            LoggerUtil.e("\u52a0\u5bc6\u5931\u8d25{}", exception.getMessage());
            return null;
        }
        object = Hex.decode((String)string3);
        KeyFactory keyFactory = KeyFactory.getInstance("EC", (Provider)new BouncyCastleProvider());
        X509EncodedKeySpec x509EncodedKeySpec = new X509EncodedKeySpec((byte[])object);
        LoggerUtil.i("\u83b7\u53d6\u8f6c\u6362\u540e\u7684\u516c\u94a5");
        object = keyFactory.generatePublic(x509EncodedKeySpec);
        LoggerUtil.i("\u5f00\u59cb\u52a0\u5bc6");
        ParametersWithRandom parametersWithRandom2 = parametersWithRandom;
        parametersWithRandom = new ParametersWithRandom((CipherParameters)ECUtil.generatePublicKeyParameter((PublicKey)object), new SecureRandom());
        SM2Engine sM2Engine = new SM2Engine();
        sM2Engine.init(true, (CipherParameters)parametersWithRandom2);
        byte[] byArray = string2.getBytes();
        int n = 0;
        return Base64.toBase64String((byte[])sM2Engine.processBlock(byArray, n, string2.getBytes().length));
    }

    public static String decryptSm2(String object, String string2) {
        try {
            LoggerUtil.i("\u79c1\u94a5\u8f6c\u6362");
            object = Base64.decode((String)object);
        }
        catch (Exception exception) {
            LoggerUtil.e("sm2\u89e3\u5bc6\u5931\u8d25{}", exception.getMessage());
            return null;
        }
        PrivateKey privateKey = KeyFactory.getInstance("EC", "BC").generatePrivate(new PKCS8EncodedKeySpec((byte[])object));
        LoggerUtil.i("sm2\u5f00\u59cb\u89e3\u5bc6");
        object = ECUtil.generatePrivateKeyParameter((PrivateKey)((BCECPrivateKey)privateKey));
        SM2Engine sM2Engine = new SM2Engine();
        sM2Engine.init(false, (CipherParameters)object);
        byte[] byArray = Base64.decode((String)string2);
        int n = 0;
        byte[] byArray2 = sM2Engine.processBlock(byArray, n, Base64.decode((String)string2).length);
        return new String(byArray2);
    }
}

