/*
 * Decompiled with CFR 0.152.
 */
package com.trustdecision.liveness.cw.util.assets;

import android.content.res.AssetManager;
import android.net.Uri;
import android.text.TextUtils;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class AssetFile {
    private final String a;
    private final String b;
    private Boolean c;

    public AssetFile() {
        this("");
    }

    public AssetFile(AssetFile assetFile, String string2) {
        this(assetFile.getAssetPath(), string2);
    }

    public AssetFile(String string2, String string3) {
        this(AssetFile.parserPath(string2, string3));
    }

    public AssetFile(String string2) {
        if (string2 == null) {
            string2 = "";
        }
        this.a = string2;
        this.b = AssetFile.parserName(string2);
    }

    public static String parserPath(String string2, String string3) {
        if (TextUtils.isEmpty((CharSequence)string2)) {
            return string3;
        }
        return string2 + File.separator + string3;
    }

    public static String parserName(String string2) {
        if (TextUtils.isEmpty((CharSequence)string2)) {
            return "";
        }
        String string3 = string2;
        int n = string3.lastIndexOf(File.separatorChar) + 1;
        return string3.substring(n, string3.length());
    }

    public String getParent() {
        AssetFile assetFile = this;
        int n = assetFile.a.lastIndexOf(File.separatorChar);
        return assetFile.a.substring(0, n);
    }

    public AssetFile getParentFile() {
        return new AssetFile(this.getParent());
    }

    public Uri getUri() {
        StringBuilder stringBuilder = new StringBuilder().append("file:///android_asset/");
        String string2 = ((AssetFile)((Object)string2)).isRootDir() ? "" : ((AssetFile)((Object)string2)).a;
        return Uri.parse((String)stringBuilder.append(string2).toString());
    }

    public boolean isRootDir() {
        return this.a.equals(File.separator);
    }

    protected Boolean a() {
        return this.c;
    }

    public boolean isDirectory(AssetManager assetManager) {
        if (this.c == null) {
            boolean bl = assetManager.list(this.a).length > 0;
            try {
                this.c = bl;
            }
            catch (Exception exception) {
                this.c = Boolean.FALSE;
            }
        }
        return this.c;
    }

    public List<AssetFile> listFiles(AssetManager assetManager) {
        SystemAssetFileFilter systemAssetFileFilter;
        AssetFile assetFile = systemAssetFileFilter2;
        SystemAssetFileFilter systemAssetFileFilter2 = systemAssetFileFilter;
        systemAssetFileFilter = new SystemAssetFileFilter();
        return assetFile.listFiles(assetManager, systemAssetFileFilter2);
    }

    public List<AssetFile> listFiles(AssetManager stringArray, AssetFileFilter assetFileFilter) {
        int n;
        ArrayList<AssetFile> arrayList;
        block14: {
            Object object;
            block13: {
                if (!TextUtils.isEmpty((CharSequence)((AssetFile)object).a)) break block13;
                object = "";
                break block14;
            }
            object = ((AssetFile)object).a;
        }
        stringArray = stringArray.list((String)object);
        ArrayList<AssetFile> arrayList2 = arrayList;
        try {
            arrayList = new ArrayList<AssetFile>();
            n = 0;
        }
        catch (IOException iOException) {
            return new ArrayList<AssetFile>();
        }
        while (true) {
            block15: {
                AssetFile assetFile;
                if (n >= stringArray.length) break;
                AssetFileFilter assetFileFilter2 = assetFileFilter;
                AssetFile assetFile2 = assetFile;
                assetFile = new AssetFile((String)object, stringArray[n]);
                if (assetFileFilter2 != null) {
                    if (!assetFileFilter.accept(assetFile2)) break block15;
                }
                arrayList2.add(assetFile2);
            }
            ++n;
        }
        return arrayList2;
    }

    public boolean exists(AssetManager assetManager) {
        try {
            assetManager.list(this.a);
        }
        catch (Exception exception) {
            return false;
        }
        return true;
    }

    public String getName() {
        return this.b;
    }

    public String getAssetPath() {
        return this.a;
    }

    static class SystemAssetFileFilter
    implements AssetFileFilter {
        private final String[] a;
        private List<String> b;

        public SystemAssetFileFilter() {
            String[] stringArray = new String[12];
            String[] stringArray2 = stringArray;
            stringArray[0] = "device_features";
            stringArray[1] = "huangli.idf";
            stringArray[2] = "hybrid";
            stringArray[3] = "images";
            stringArray[4] = "keys";
            stringArray[5] = "license";
            stringArray[6] = "operators.dat";
            stringArray[7] = "pinyinindex.idf";
            stringArray[8] = "sounds";
            stringArray[9] = "telocation.idf";
            stringArray[10] = "webkit";
            stringArray[11] = "xiaomi_mobile.dat";
            v1.a = stringArray;
            stringArray2.b = Arrays.asList(stringArray2);
        }

        @Override
        public boolean accept(AssetFile assetFile) {
            return this.b.contains(assetFile.getName()) ^ true;
        }
    }

    static interface AssetFileFilter {
        public boolean accept(AssetFile var1);
    }
}

