/*
 * Decompiled with CFR 0.152.
 */
package com.trustdecision.liveness.cw.sdk.entity.live;

import com.trustdecision.liveness.cw.live.struct.CwFace;
import com.trustdecision.liveness.cw.live.struct.CwFacePoint;
import com.trustdecision.liveness.cw.sdk.entity.live.FaceAligned;
import com.trustdecision.liveness.cw.sdk.entity.live.FaceHeadPose;
import com.trustdecision.liveness.cw.sdk.entity.live.FaceKeyPoint;
import com.trustdecision.liveness.cw.sdk.entity.live.FaceLiveness;
import com.trustdecision.liveness.cw.sdk.entity.live.FaceQuality;
import com.trustdecision.liveness.cw.sdk.entity.live.FaceRect;

public class FaceInfo {
    private int detected;
    private int faceId;
    private FaceRect rect;
    private FaceKeyPoint keyPoint;
    private FaceHeadPose headPose;
    private FaceQuality quality;
    private FaceLiveness liveness;
    private FaceAligned aligned;

    public FaceInfo(CwFace cwFace) {
        if (cwFace != null) {
            FaceInfo faceInfo = this;
            this.detected = cwFace.detected;
            faceInfo.faceId = cwFace.faceId;
            faceInfo.rect = new FaceRect(cwFace.faceRect);
            CwFacePoint[] cwFacePointArray = cwFace.keypt;
            if (cwFace.keypt != null) {
                FaceKeyPoint faceKeyPoint;
                FaceKeyPoint faceKeyPoint2 = faceKeyPoint;
                cwFacePointArray = cwFacePointArray.points;
                int n = cwFacePointArray.nkeypt;
                float f2 = cwFacePointArray.keyptScore;
                faceKeyPoint = new FaceKeyPoint(cwFacePointArray, n, f2);
                this.keyPoint = faceKeyPoint2;
            }
            FaceInfo faceInfo2 = this;
            faceInfo2.headPose = new FaceHeadPose(cwFace.headPose);
            faceInfo2.aligned = new FaceAligned(cwFace.faceAligned);
            faceInfo2.quality = new FaceQuality(cwFace.quality);
            faceInfo2.liveness = new FaceLiveness(cwFace.liveness);
        }
    }

    public int getDetected() {
        return this.detected;
    }

    public int getFaceId() {
        return this.faceId;
    }

    public FaceRect getRect() {
        return this.rect;
    }

    public FaceKeyPoint getKeyPoint() {
        return this.keyPoint;
    }

    public FaceHeadPose getHeadPose() {
        return this.headPose;
    }

    public FaceQuality getQuality() {
        return this.quality;
    }

    public FaceLiveness getLiveness() {
        return this.liveness;
    }

    public FaceAligned getAligned() {
        return this.aligned;
    }

    public String toString() {
        return "FaceInfo{detected=" + this.detected + ", faceId=" + this.faceId + ", rect=" + this.rect + ", keyPoint=" + this.keyPoint + ", headPose=" + this.headPose + ", quality=" + this.quality + ", liveness=" + this.liveness + ", aligned=" + this.aligned + '}';
    }
}

