/*
 * Decompiled with CFR 0.152.
 */
package com.truebanana.file;

import android.net.Uri;
import android.webkit.MimeTypeMap;
import java.io.File;
import java.text.DecimalFormat;

public class FileUtils {
    private static String[] decimalByteUnits;
    private static String[] binaryByteUnits;
    private static DecimalFormat fileSizeFormat;

    public static String getMimeType(File file) {
        return MimeTypeMap.getSingleton().getMimeTypeFromExtension(FileUtils.getExtension(file));
    }

    public static String getExtensionFromMimeType(String mimeType) {
        return MimeTypeMap.getSingleton().getExtensionFromMimeType(mimeType);
    }

    public static String getExtension(File file) {
        return FileUtils.getExtension(Uri.fromFile((File)file));
    }

    public static String getExtension(Uri uri) {
        return MimeTypeMap.getFileExtensionFromUrl((String)uri.toString());
    }

    public static boolean isImage(File file) {
        String mimeType = FileUtils.getMimeType(file);
        return mimeType != null && mimeType.startsWith("image");
    }

    public static boolean isVideo(File file) {
        String mimeType = FileUtils.getMimeType(file);
        return mimeType != null && mimeType.startsWith("video");
    }

    public static String getFormattedFileSize(long bytes) {
        return FileUtils.getFormattedFileSize(bytes, false);
    }

    public static String getFormattedFileSize(long bytes, boolean binary) {
        return FileUtils.getFormattedFileSize(bytes, binary, binary);
    }

    public static String getFormattedFileSize(long bytes, boolean binaryCalculation, boolean binaryUnits) {
        if (binaryByteUnits == null) {
            decimalByteUnits = new String[]{"B", "kB", "MB", "GB", "TB", "PB", "EB", "ZB", "YB"};
            binaryByteUnits = new String[]{"B", "KiB", "MiB", "GiB", "TiB", "PiB", "EiB", "ZiB", "YiB"};
            fileSizeFormat = new DecimalFormat("0.00");
        }
        double b = bytes;
        int loops = 0;
        String[] units = binaryUnits ? binaryByteUnits : decimalByteUnits;
        int divisor = binaryCalculation ? 1024 : 1000;
        while (b > (double)divisor & loops < units.length - 1) {
            b /= (double)divisor;
            ++loops;
        }
        return fileSizeFormat.format(b) + " " + units[loops];
    }
}

