/*
 * Decompiled with CFR 0.152.
 */
package com.truebanana.view;

import android.graphics.Typeface;
import android.view.View;
import android.view.ViewGroup;
import android.widget.Button;
import android.widget.CheckBox;
import android.widget.EditText;
import android.widget.RadioButton;
import android.widget.Spinner;
import android.widget.SpinnerAdapter;
import android.widget.TextView;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class ViewUtils {
    public static int getInt(EditText editText) {
        int value = 0;
        try {
            value = Integer.parseInt(editText.getText().toString());
        }
        catch (NumberFormatException e) {
            e.printStackTrace();
        }
        return value;
    }

    public static long getLong(EditText editText) {
        long value = 0L;
        try {
            value = Long.parseLong(editText.getText().toString());
        }
        catch (NumberFormatException e) {
            e.printStackTrace();
        }
        return value;
    }

    public static double getDouble(EditText editText) {
        double value = 0.0;
        try {
            value = Double.parseDouble(editText.getText().toString());
        }
        catch (NumberFormatException e) {
            e.printStackTrace();
        }
        return value;
    }

    public static float getFloat(EditText editText) {
        float value = 0.0f;
        try {
            value = Float.parseFloat(editText.getText().toString());
        }
        catch (NumberFormatException e) {
            e.printStackTrace();
        }
        return value;
    }

    public static String getString(EditText editText) {
        return editText.getText().toString();
    }

    public static int getLength(EditText editText) {
        return editText.getText().toString().length();
    }

    public static String getSelectedItem(Spinner spinner) {
        return spinner.getSelectedItem().toString();
    }

    public static void setSelectedItem(Spinner spinner, String item) {
        SpinnerAdapter vAdapter = spinner.getAdapter();
        for (int i = 0; i < vAdapter.getCount(); ++i) {
            if (!item.equals(vAdapter.getItem(i).toString())) continue;
            spinner.setSelection(i);
            break;
        }
    }

    public static List<View> getViewsByTag(ViewGroup parentView, Object tag) {
        ArrayList<View> views = new ArrayList<View>();
        int childCount = parentView.getChildCount();
        for (int i = 0; i < childCount; ++i) {
            Object tagObj;
            View child = parentView.getChildAt(i);
            if (child instanceof ViewGroup) {
                views.addAll(ViewUtils.getViewsByTag((ViewGroup)child, tag));
            }
            if ((tagObj = child.getTag()) == null || !tagObj.equals(tag)) continue;
            views.add(child);
        }
        return views;
    }

    public static void setVisibility(int visibility, View ... views) {
        ViewUtils.setVisibility(visibility, Arrays.asList(views));
    }

    public static void setVisibility(int visibility, List<View> views) {
        for (View view : views) {
            view.setVisibility(visibility);
        }
    }

    public static void setVisible(View ... views) {
        ViewUtils.setVisibility(0, views);
    }

    public static void setVisible(List<View> views) {
        ViewUtils.setVisibility(0, views);
    }

    public static void setInvisible(View ... views) {
        ViewUtils.setVisibility(4, views);
    }

    public static void setInvisible(List<View> views) {
        ViewUtils.setVisibility(4, views);
    }

    public static void setGone(View ... views) {
        ViewUtils.setVisibility(8, views);
    }

    public static void setGone(List<View> views) {
        ViewUtils.setVisibility(8, views);
    }

    public static void setTypeface(Typeface typeface, View ... views) {
        ViewUtils.setTypeface(typeface, Arrays.asList(views));
    }

    public static void setTypeface(Typeface typeface, List<View> views) {
        for (View view : views) {
            if (view instanceof TextView) {
                ((TextView)view).setTypeface(typeface);
                continue;
            }
            if (view instanceof EditText) {
                ((EditText)view).setTypeface(typeface);
                continue;
            }
            if (view instanceof Button) {
                ((Button)view).setTypeface(typeface);
                continue;
            }
            if (view instanceof CheckBox) {
                ((CheckBox)view).setTypeface(typeface);
                continue;
            }
            if (!(view instanceof RadioButton)) continue;
            ((RadioButton)view).setTypeface(typeface);
        }
    }
}

