/*
 * Decompiled with CFR 0.152.
 */
package com.truebanana.system;

import android.content.ContentResolver;
import android.content.Context;
import android.content.res.Resources;
import android.location.LocationManager;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.os.Build;
import android.provider.Settings;
import android.telephony.TelephonyManager;
import java.net.NetworkInterface;
import java.util.ArrayList;
import java.util.Collections;

public class SystemUtils {
    public static int getSDKVersion() {
        return Build.VERSION.SDK_INT;
    }

    public static String getDeviceID(Context context) {
        return Settings.Secure.getString((ContentResolver)context.getContentResolver(), (String)"android_id");
    }

    public static float convertDPToPX(float dp) {
        return dp * Resources.getSystem().getDisplayMetrics().density;
    }

    public static float convertPXToDP(float px) {
        return px / Resources.getSystem().getDisplayMetrics().density;
    }

    public static boolean isNetworkConnected(Context context) {
        ConnectivityManager cm = (ConnectivityManager)context.getSystemService("connectivity");
        NetworkInfo ni = cm.getActiveNetworkInfo();
        return ni != null && ni.isConnected();
    }

    public static int getNetworkConnectionType(Context context) {
        ConnectivityManager cm = (ConnectivityManager)context.getSystemService("connectivity");
        NetworkInfo ni = cm.getActiveNetworkInfo();
        int networkConnectionType = -1;
        if (ni != null && ni.isConnected()) {
            networkConnectionType = ni.getType();
        }
        return networkConnectionType;
    }

    public static String getNetworkConnectionTypeName(Context context) {
        ConnectivityManager cm = (ConnectivityManager)context.getSystemService("connectivity");
        NetworkInfo ni = cm.getActiveNetworkInfo();
        String networkConnectionType = "";
        if (ni != null && ni.isConnected()) {
            networkConnectionType = ni.getTypeName();
        }
        return networkConnectionType;
    }

    public static String getMACAddress(String interfaceName) {
        try {
            ArrayList<NetworkInterface> interfaces = Collections.list(NetworkInterface.getNetworkInterfaces());
            for (NetworkInterface networkInterface : interfaces) {
                if (interfaceName != null && !networkInterface.getName().equalsIgnoreCase(interfaceName)) continue;
                byte[] mac = networkInterface.getHardwareAddress();
                if (mac == null) {
                    return "";
                }
                StringBuilder buf = new StringBuilder();
                for (int i = 0; i < mac.length; ++i) {
                    buf.append(String.format("%02X:", mac[i]));
                }
                if (buf.length() > 0) {
                    buf.deleteCharAt(buf.length() - 1);
                }
                return buf.toString();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return "";
    }

    public static String getNetworkOperatorName(Context context) {
        TelephonyManager tm = (TelephonyManager)context.getSystemService("phone");
        return tm.getNetworkOperatorName();
    }

    public static String getSIMOperatorName(Context context) {
        TelephonyManager tm = (TelephonyManager)context.getSystemService("phone");
        return tm.getSimOperatorName();
    }

    public static String getPhoneTypeName(int phoneType) {
        String phoneTypeName = "NONE";
        switch (phoneType) {
            case 2: {
                phoneTypeName = "CDMA";
                break;
            }
            case 1: {
                phoneTypeName = "GSM";
                break;
            }
            case 0: {
                phoneTypeName = "NONE";
                break;
            }
            case 3: {
                phoneTypeName = "SIP";
            }
        }
        return phoneTypeName;
    }

    public static String getNetworkTypeName(int networkType) {
        String networkTypeName = "UNKNOWN";
        switch (networkType) {
            case 7: {
                networkTypeName = "1xRTT";
                break;
            }
            case 4: {
                networkTypeName = "CDMA";
                break;
            }
            case 2: {
                networkTypeName = "EDGE";
                break;
            }
            case 14: {
                networkTypeName = "EHRPD";
                break;
            }
            case 5: {
                networkTypeName = "EVDO_0";
                break;
            }
            case 6: {
                networkTypeName = "EVDO_A";
                break;
            }
            case 12: {
                networkTypeName = "EVDO_B";
                break;
            }
            case 1: {
                networkTypeName = "GPRS";
                break;
            }
            case 8: {
                networkTypeName = "HSDPA";
                break;
            }
            case 10: {
                networkTypeName = "HSPA";
                break;
            }
            case 15: {
                networkTypeName = "HSPAP";
                break;
            }
            case 9: {
                networkTypeName = "HSUPA";
                break;
            }
            case 11: {
                networkTypeName = "IDEN";
                break;
            }
            case 13: {
                networkTypeName = "LTE";
                break;
            }
            case 3: {
                networkTypeName = "UMTS";
                break;
            }
            case 0: {
                networkTypeName = "UNKNOWN";
            }
        }
        return networkTypeName;
    }

    public static boolean isProviderEnabled(Context context, String provider) {
        LocationManager lm = (LocationManager)context.getSystemService("location");
        return lm.isProviderEnabled(provider);
    }

    public static boolean isGPSEnabled(Context context) {
        return SystemUtils.isProviderEnabled(context, "gps");
    }

    public static boolean isNetworkLocationProviderEnabled(Context context) {
        return SystemUtils.isProviderEnabled(context, "network");
    }

    public static boolean isPassiveLocationProviderEnabled(Context context) {
        return SystemUtils.isProviderEnabled(context, "passive");
    }
}

