/*
 * Decompiled with CFR 0.152.
 */
package com.truebanana.http;

import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class MultiPartContent {
    private String boundary = "**********";
    private List<Part> parts = new ArrayList<Part>();

    private MultiPartContent() {
    }

    public static MultiPartContent create() {
        MultiPartContent mpc = new MultiPartContent();
        return mpc;
    }

    protected void write(OutputStream outputStream) throws IOException {
        String crlf = "\r\n";
        String hypens = "--";
        DataOutputStream os = new DataOutputStream(outputStream);
        for (Part part : this.parts) {
            os.writeBytes(hypens + this.boundary + crlf);
            os.writeBytes("Content-Disposition: form-data; name=\"" + part.getName() + "\";filename=\"" + part.getFileName() + "\"" + crlf);
            for (Map.Entry<String, String> pair : part.getHeaders().entrySet()) {
                os.writeBytes(pair.getKey() + ": " + pair.getValue());
                os.writeBytes(crlf);
            }
            os.writeBytes(crlf);
            os.write(part.getContent());
        }
        os.writeBytes(crlf);
        os.writeBytes(hypens + this.boundary + hypens + crlf);
        os.flush();
        os.close();
    }

    public MultiPartContent addPart(Part part) {
        this.parts.add(part);
        return this;
    }

    public MultiPartContent setBoundary(String boundary) {
        this.boundary = boundary;
        return this;
    }

    public List<Part> getParts() {
        return this.parts;
    }

    public String getBoundary() {
        return this.boundary;
    }

    public static class Part {
        private String name;
        private String fileName;
        private byte[] content;
        private Map<String, String> headers = new HashMap<String, String>();

        private Part() {
        }

        public static Part create(String name, String fileName, byte[] content) {
            Part part = new Part();
            part.name = name;
            part.fileName = fileName;
            part.content = content;
            return part;
        }

        public Part addHeader(String key, String value) {
            this.headers.put(key, value);
            return this;
        }

        public String getName() {
            return this.name;
        }

        public String getFileName() {
            return this.fileName;
        }

        public byte[] getContent() {
            return this.content;
        }

        public Map<String, String> getHeaders() {
            return this.headers;
        }
    }
}

