/*
 * Decompiled with CFR 0.152.
 */
package com.truebanana.http;

import com.truebanana.http.HTTPRequest;
import com.truebanana.json.JSONUtils;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.util.List;
import java.util.Map;
import org.json.JSONArray;
import org.json.JSONObject;

public class HTTPResponse {
    protected byte[] content = new byte[0];
    protected String stringContent;
    protected int statusCode = -1;
    protected String responseMessage;
    protected Map<String, List<String>> headers;
    protected String requestURL;
    protected HTTPRequest originalRequest;

    protected HTTPResponse() {
    }

    protected static HTTPResponse from(HTTPRequest request, HttpURLConnection connection, InputStream content) {
        HTTPResponse response = new HTTPResponse();
        response.originalRequest = request;
        if (content != null) {
            try {
                int nRead;
                ByteArrayOutputStream buffer = new ByteArrayOutputStream();
                byte[] data = new byte[16384];
                while ((nRead = content.read(data, 0, data.length)) != -1) {
                    buffer.write(data, 0, nRead);
                }
                buffer.flush();
                response.content = buffer.toByteArray();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        try {
            response.statusCode = connection.getResponseCode();
        }
        catch (IOException e) {
            // empty catch block
        }
        String message = null;
        try {
            message = connection.getResponseMessage();
        }
        catch (IOException e) {
            message = e.getLocalizedMessage();
        }
        response.responseMessage = response.statusCode + (message != null ? " " + message : "");
        response.headers = connection.getHeaderFields();
        response.requestURL = connection.getURL().toString();
        return response;
    }

    public HTTPRequest getOriginalRequest() {
        return this.originalRequest;
    }

    public String getRequestURL() {
        return this.requestURL;
    }

    public int getStatusCode() {
        return this.statusCode;
    }

    public byte[] getContent() {
        return this.content;
    }

    public String getStringContent() {
        if (this.stringContent == null) {
            this.stringContent = new String(this.content);
        }
        return this.stringContent;
    }

    public JSONObject toJSONObject() {
        return JSONUtils.toJSONObject(this.getStringContent());
    }

    public JSONArray toJSONArray() {
        return JSONUtils.toJSONArray(this.getStringContent());
    }

    public String getResponseMessage() {
        return this.responseMessage;
    }

    public Map<String, List<String>> getHeaders() {
        return this.headers;
    }

    public String getHeaderField(String key) {
        return this.headers.containsKey(key) ? this.headers.get(key).get(0) : null;
    }

    public boolean isInformational() {
        return this.statusCode >= 100 && this.statusCode < 200;
    }

    public boolean isSuccess() {
        return this.statusCode >= 200 && this.statusCode < 300;
    }

    public boolean isRedirection() {
        return this.statusCode >= 300 && this.statusCode < 400;
    }

    public boolean isClientError() {
        return this.statusCode >= 400 && this.statusCode < 500;
    }

    public boolean isServerError() {
        return this.statusCode >= 500 && this.statusCode < 600;
    }

    public boolean isConnectionError() {
        return this.statusCode == -1;
    }
}

