/*
 * Decompiled with CFR 0.152.
 */
package com.truebanana.http;

import android.graphics.Bitmap;
import com.truebanana.async.Async;
import com.truebanana.async.BackgroundTask;
import com.truebanana.bitmap.BitmapUtils;
import com.truebanana.http.HTTPRequestError;
import com.truebanana.http.HTTPResponse;
import com.truebanana.http.HTTPResponseListener;

public abstract class BitmapResponseListener
implements HTTPResponseListener {
    private int width;
    private int height;

    public BitmapResponseListener(int width, int height) {
        this.width = width;
        this.height = height;
    }

    public BitmapResponseListener() {
        this(0, 0);
    }

    public abstract void onDecodingSuccessful(Bitmap var1);

    public abstract void onDecodingFailed();

    @Override
    public void onPreExecute() {
    }

    @Override
    public void onPostExecute() {
    }

    @Override
    public final void onRequestCompleted(final HTTPResponse response) {
        Async.executeAsync(new BackgroundTask<Bitmap>(){

            @Override
            public Bitmap doInBackground() {
                return BitmapUtils.decodeBytes(response.getContent(), BitmapResponseListener.this.width, BitmapResponseListener.this.height);
            }

            @Override
            public void onPostExecute(Bitmap bitmap) {
                if (bitmap != null) {
                    BitmapResponseListener.this.onDecodingSuccessful(bitmap);
                } else {
                    BitmapResponseListener.this.onDecodingFailed();
                }
            }
        });
    }

    @Override
    public void onRequestError(HTTPRequestError error) {
    }
}

