/*
 * Decompiled with CFR 0.152.
 */
package com.truebanana.cursor;

import android.database.Cursor;
import android.text.TextUtils;

public class CursorUtils {
    public static String getString(Cursor cursor, String columnName, String defaultValue) {
        int index;
        String value = defaultValue;
        if (cursor != null && !TextUtils.isEmpty((CharSequence)columnName) && (index = cursor.getColumnIndex(columnName)) != -1) {
            value = cursor.getString(index);
        }
        return value;
    }

    public static String getString(Cursor cursor, String columnName) {
        return CursorUtils.getString(cursor, columnName, null);
    }

    public static byte[] getBlob(Cursor cursor, String columnName, byte[] defaultValue) {
        int index;
        byte[] value = defaultValue;
        if (cursor != null && !TextUtils.isEmpty((CharSequence)columnName) && (index = cursor.getColumnIndex(columnName)) != -1) {
            value = cursor.getBlob(index);
        }
        return value;
    }

    public static byte[] getBlob(Cursor cursor, String columnName) {
        return CursorUtils.getBlob(cursor, columnName, null);
    }

    public static int getInt(Cursor cursor, String columnName, int defaultValue) {
        int index;
        int value = defaultValue;
        if (cursor != null && !TextUtils.isEmpty((CharSequence)columnName) && (index = cursor.getColumnIndex(columnName)) != -1) {
            value = cursor.getInt(index);
        }
        return value;
    }

    public static long getLong(Cursor cursor, String columnName, long defaultValue) {
        int index;
        long value = defaultValue;
        if (cursor != null && !TextUtils.isEmpty((CharSequence)columnName) && (index = cursor.getColumnIndex(columnName)) != -1) {
            value = cursor.getLong(index);
        }
        return value;
    }

    public static float getFloat(Cursor cursor, String columnName, float defaultValue) {
        int index;
        float value = defaultValue;
        if (cursor != null && !TextUtils.isEmpty((CharSequence)columnName) && (index = cursor.getColumnIndex(columnName)) != -1) {
            value = cursor.getFloat(index);
        }
        return value;
    }

    public static double getDouble(Cursor cursor, String columnName, double defaultValue) {
        int index;
        double value = defaultValue;
        if (cursor != null && !TextUtils.isEmpty((CharSequence)columnName) && (index = cursor.getColumnIndex(columnName)) != -1) {
            value = cursor.getDouble(index);
        }
        return value;
    }
}

