/*
 * Decompiled with CFR 0.152.
 */
package com.truebanana.cache;

import android.content.Context;
import com.truebanana.cache.DiskLruCache;
import com.truebanana.crypto.Crypto;
import com.truebanana.log.Log;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.commons.io.IOUtils;

public abstract class AbstractDiskLruCache<T> {
    private DiskLruCache cache;

    public AbstractDiskLruCache(Context context) {
        this(context, 0xA00000L);
    }

    public AbstractDiskLruCache(Context context, long maxSize) {
        this(context.getCacheDir(), maxSize);
    }

    public AbstractDiskLruCache(File directory) {
        this(directory, 0xA00000L);
    }

    public AbstractDiskLruCache(File directory, long maxSize) {
        try {
            this.cache = DiskLruCache.open(directory, 1, 1, maxSize);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private boolean writeToFile(byte[] data, OutputStream os) {
        try {
            IOUtils.write((byte[])data, (OutputStream)os);
            os.flush();
            os.close();
            Log.d("AbstractDiskLruCache", "Write file to disk successful");
            return true;
        }
        catch (IOException e) {
            Log.d("AbstractDiskLruCache", "Write file to disk failed");
            return false;
        }
    }

    public File getDirectory() {
        return this.cache.getDirectory();
    }

    public long getSize() {
        return this.cache.size();
    }

    public long getMaxSize() {
        return this.cache.maxSize();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean contains(String key) {
        key = Crypto.SHA1(key);
        boolean contains = false;
        try (DiskLruCache.Snapshot snapshot = null;){
            snapshot = this.cache.get(key);
            contains = snapshot != null;
        }
        return contains;
    }

    public void clear() {
        try {
            this.cache.delete();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected byte[] getData(String key) {
        key = Crypto.SHA1(key);
        byte[] data = null;
        try (DiskLruCache.Snapshot snapshot = null;){
            snapshot = this.cache.get(key);
            if (snapshot != null) {
                InputStream is = snapshot.getInputStream(0);
                data = IOUtils.toByteArray((InputStream)is);
            }
        }
        return data;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void putData(String key, byte[] data) {
        key = Crypto.SHA1(key);
        DiskLruCache.Editor editor = null;
        boolean success = false;
        try {
            editor = this.cache.edit(key);
            if (this.writeToFile(data, editor.newOutputStream(0))) {
                this.cache.flush();
                editor.commit();
                success = true;
                this.cache.close();
                this.cache = DiskLruCache.open(this.getDirectory(), 1, 1, this.getMaxSize());
            }
        }
        catch (IOException e) {
            Log.d("AbstractDiskLruCache", "Put data in cache failed");
        }
        finally {
            if (!success && editor != null) {
                try {
                    editor.abort();
                }
                catch (IOException iOException) {}
            }
        }
    }

    public abstract T get(String var1);

    public abstract void put(String var1, T var2);
}

