/*
 * Decompiled with CFR 0.152.
 */
package com.truebanana.bitmap;

import android.annotation.SuppressLint;
import android.content.Context;
import android.database.Cursor;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Matrix;
import android.graphics.Rect;
import android.media.ExifInterface;
import android.net.Uri;
import android.renderscript.Allocation;
import android.renderscript.Element;
import android.renderscript.RenderScript;
import android.renderscript.ScriptIntrinsicBlur;
import com.truebanana.bitmap.DecodeFileListener;
import com.truebanana.bitmap.DecodeFileTask;
import com.truebanana.http.BitmapResponseListener;
import com.truebanana.http.HTTPRequest;
import com.truebanana.system.SystemUtils;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.io.IOUtils;

public class BitmapUtils {
    public static BitmapFactory.Options getBounds(File file) {
        return BitmapUtils.getBounds(file, new BitmapFactory.Options());
    }

    public static BitmapFactory.Options getBounds(File file, BitmapFactory.Options options) {
        options.inJustDecodeBounds = true;
        BitmapFactory.decodeFile((String)file.getPath(), (BitmapFactory.Options)options);
        return options;
    }

    public static BitmapFactory.Options getBounds(InputStream inputStream) {
        return BitmapUtils.getBounds(inputStream, new BitmapFactory.Options());
    }

    public static BitmapFactory.Options getBounds(InputStream inputStream, BitmapFactory.Options options) {
        options.inJustDecodeBounds = true;
        BitmapFactory.decodeStream((InputStream)inputStream, (Rect)new Rect(), (BitmapFactory.Options)options);
        return options;
    }

    public static BitmapFactory.Options getBounds(byte[] bytes) {
        return BitmapUtils.getBounds(bytes, new BitmapFactory.Options());
    }

    public static BitmapFactory.Options getBounds(byte[] bytes, BitmapFactory.Options options) {
        options.inJustDecodeBounds = true;
        BitmapFactory.decodeByteArray((byte[])bytes, (int)0, (int)bytes.length, (BitmapFactory.Options)options);
        return options;
    }

    public static int getInSampleSize(BitmapFactory.Options optionsWithBounds, int targetWidth, int targetHeight) {
        return BitmapUtils.getInSampleSize(optionsWithBounds.outWidth, optionsWithBounds.outHeight, targetWidth, targetHeight);
    }

    public static int getInSampleSize(int width, int height, int targetWidth, int targetHeight) {
        int inSampleSize = 1;
        if (width > targetWidth || height > targetHeight) {
            int halfWidth = width / 2;
            int halfHeight = height / 2;
            while (halfWidth / inSampleSize > targetWidth && halfHeight / inSampleSize > targetHeight) {
                inSampleSize *= 2;
            }
        }
        return inSampleSize;
    }

    public static Bitmap decodeFile(File file) {
        return BitmapUtils.decodeFile(file, 0, 0);
    }

    public static Bitmap decodeFile(File file, int targetWidth, int targetHeight) {
        if (targetWidth > 1 && targetHeight > 1) {
            BitmapFactory.Options options = BitmapUtils.getBounds(file);
            options.inJustDecodeBounds = false;
            options.inSampleSize = BitmapUtils.getInSampleSize(options, targetWidth, targetHeight);
            return BitmapFactory.decodeFile((String)file.getPath(), (BitmapFactory.Options)options);
        }
        return BitmapFactory.decodeFile((String)file.getPath());
    }

    public static DecodeFileTask decodeFileAsync(File file, int targetWidth, int targetHeight, DecodeFileListener listener) {
        DecodeFileTask task = new DecodeFileTask(file, targetWidth, targetHeight, listener);
        task.execute(new Void[0]);
        return task;
    }

    public static Bitmap decodeStream(InputStream inputStream) {
        return BitmapUtils.decodeStream(inputStream, 0, 0);
    }

    public static Bitmap decodeStream(InputStream inputStream, int targetWidth, int targetHeight) {
        try {
            byte[] bytes = IOUtils.toByteArray((InputStream)inputStream);
            ByteArrayInputStream is1 = new ByteArrayInputStream(bytes);
            ByteArrayInputStream is2 = new ByteArrayInputStream(bytes);
            if (targetWidth > 1 && targetHeight > 1) {
                BitmapFactory.Options options = BitmapUtils.getBounds(is1);
                options.inJustDecodeBounds = false;
                options.inSampleSize = BitmapUtils.getInSampleSize(options, targetWidth, targetHeight);
                return BitmapFactory.decodeStream((InputStream)is2, (Rect)new Rect(), (BitmapFactory.Options)options);
            }
            return BitmapFactory.decodeStream((InputStream)is2);
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static Bitmap decodeBytes(byte[] bytes) {
        return BitmapUtils.decodeBytes(bytes, 0, 0);
    }

    public static Bitmap decodeBytes(byte[] bytes, int targetWidth, int targetHeight) {
        if (targetWidth > 1 && targetHeight > 1) {
            BitmapFactory.Options options = BitmapUtils.getBounds(bytes);
            options.inJustDecodeBounds = false;
            options.inSampleSize = BitmapUtils.getInSampleSize(options, targetWidth, targetHeight);
            return BitmapFactory.decodeByteArray((byte[])bytes, (int)0, (int)bytes.length, (BitmapFactory.Options)options);
        }
        return BitmapFactory.decodeByteArray((byte[])bytes, (int)0, (int)bytes.length);
    }

    public static void decodeFromURL(String url, BitmapResponseListener listener) {
        HTTPRequest.create(url).setHTTPResponseListener(listener).executeAsync();
    }

    public static Bitmap crop(Bitmap bitmap, int targetWidth, int targetHeight, int x, int y) {
        return Bitmap.createBitmap((Bitmap)bitmap, (int)x, (int)y, (int)targetWidth, (int)targetHeight);
    }

    public static Bitmap correctOrientation(Bitmap bitmap, int orientation) {
        Matrix matrix = new Matrix();
        matrix.postRotate((float)orientation);
        return Bitmap.createBitmap((Bitmap)bitmap, (int)0, (int)0, (int)bitmap.getWidth(), (int)bitmap.getHeight(), (Matrix)matrix, (boolean)true);
    }

    public static int getOrientation(Context context, Uri bitmapUri) {
        Cursor cursor = context.getContentResolver().query(bitmapUri, new String[]{"orientation"}, null, null, null);
        if (cursor == null || cursor.getCount() != 1) {
            return -1;
        }
        cursor.moveToFirst();
        return cursor.getInt(0);
    }

    public static int getOrientation(File file) {
        return BitmapUtils.getOrientation(file.getPath());
    }

    public static int getOrientation(String path) {
        try {
            ExifInterface exif = new ExifInterface(path);
            return exif.getAttributeInt("Orientation", 0);
        }
        catch (IOException e) {
            e.printStackTrace();
            return 0;
        }
    }

    @SuppressLint(value={"NewApi"})
    public static Bitmap blur(Context context, Bitmap bitmap, float scale, int radius) {
        int stackstart;
        int x;
        int stackpointer;
        int rbs;
        int[] sir;
        int p;
        int rinsum;
        int ginsum;
        int binsum;
        int routsum;
        int goutsum;
        int boutsum;
        int rsum;
        int gsum;
        int bsum;
        int y;
        int i;
        if (SystemUtils.getSDKVersion() >= 17) {
            int width = Math.round((float)bitmap.getWidth() * scale);
            int height = Math.round((float)bitmap.getHeight() * scale);
            bitmap = Bitmap.createScaledBitmap((Bitmap)bitmap, (int)width, (int)height, (boolean)false);
            Bitmap processedBitmap = Bitmap.createBitmap((Bitmap)bitmap);
            RenderScript rs = RenderScript.create((Context)context);
            ScriptIntrinsicBlur sib = ScriptIntrinsicBlur.create((RenderScript)rs, (Element)Element.U8_4((RenderScript)rs));
            Allocation tmpIn = Allocation.createFromBitmap((RenderScript)rs, (Bitmap)bitmap);
            Allocation tmpOut = Allocation.createFromBitmap((RenderScript)rs, (Bitmap)processedBitmap);
            sib.setRadius((float)radius);
            sib.setInput(tmpIn);
            sib.forEach(tmpOut);
            tmpOut.copyTo(processedBitmap);
            return processedBitmap;
        }
        int width = Math.round((float)bitmap.getWidth() * scale);
        int height = Math.round((float)bitmap.getHeight() * scale);
        bitmap = Bitmap.createScaledBitmap((Bitmap)bitmap, (int)width, (int)height, (boolean)false);
        Bitmap processedBitmap = bitmap.copy(bitmap.getConfig(), true);
        if (radius < 1) {
            return null;
        }
        int w = processedBitmap.getWidth();
        int h = processedBitmap.getHeight();
        int[] pix = new int[w * h];
        processedBitmap.getPixels(pix, 0, w, 0, 0, w, h);
        int wm = w - 1;
        int hm = h - 1;
        int wh = w * h;
        int div = radius + radius + 1;
        int[] r = new int[wh];
        int[] g = new int[wh];
        int[] b = new int[wh];
        int[] vmin = new int[Math.max(w, h)];
        int divsum = div + 1 >> 1;
        divsum *= divsum;
        int[] dv = new int[256 * divsum];
        for (i = 0; i < 256 * divsum; ++i) {
            dv[i] = i / divsum;
        }
        int yi = 0;
        int yw = 0;
        int[][] stack = new int[div][3];
        int r1 = radius + 1;
        for (y = 0; y < h; ++y) {
            bsum = 0;
            gsum = 0;
            rsum = 0;
            boutsum = 0;
            goutsum = 0;
            routsum = 0;
            binsum = 0;
            ginsum = 0;
            rinsum = 0;
            for (i = -radius; i <= radius; ++i) {
                p = pix[yi + Math.min(wm, Math.max(i, 0))];
                sir = stack[i + radius];
                sir[0] = (p & 0xFF0000) >> 16;
                sir[1] = (p & 0xFF00) >> 8;
                sir[2] = p & 0xFF;
                rbs = r1 - Math.abs(i);
                rsum += sir[0] * rbs;
                gsum += sir[1] * rbs;
                bsum += sir[2] * rbs;
                if (i > 0) {
                    rinsum += sir[0];
                    ginsum += sir[1];
                    binsum += sir[2];
                    continue;
                }
                routsum += sir[0];
                goutsum += sir[1];
                boutsum += sir[2];
            }
            stackpointer = radius;
            for (x = 0; x < w; ++x) {
                r[yi] = dv[rsum];
                g[yi] = dv[gsum];
                b[yi] = dv[bsum];
                rsum -= routsum;
                gsum -= goutsum;
                bsum -= boutsum;
                stackstart = stackpointer - radius + div;
                sir = stack[stackstart % div];
                routsum -= sir[0];
                goutsum -= sir[1];
                boutsum -= sir[2];
                if (y == 0) {
                    vmin[x] = Math.min(x + radius + 1, wm);
                }
                p = pix[yw + vmin[x]];
                sir[0] = (p & 0xFF0000) >> 16;
                sir[1] = (p & 0xFF00) >> 8;
                sir[2] = p & 0xFF;
                rsum += (rinsum += sir[0]);
                gsum += (ginsum += sir[1]);
                bsum += (binsum += sir[2]);
                stackpointer = (stackpointer + 1) % div;
                sir = stack[stackpointer % div];
                routsum += sir[0];
                goutsum += sir[1];
                boutsum += sir[2];
                rinsum -= sir[0];
                ginsum -= sir[1];
                binsum -= sir[2];
                ++yi;
            }
            yw += w;
        }
        for (x = 0; x < w; ++x) {
            bsum = 0;
            gsum = 0;
            rsum = 0;
            boutsum = 0;
            goutsum = 0;
            routsum = 0;
            binsum = 0;
            ginsum = 0;
            rinsum = 0;
            int yp = -radius * w;
            for (i = -radius; i <= radius; ++i) {
                yi = Math.max(0, yp) + x;
                sir = stack[i + radius];
                sir[0] = r[yi];
                sir[1] = g[yi];
                sir[2] = b[yi];
                rbs = r1 - Math.abs(i);
                rsum += r[yi] * rbs;
                gsum += g[yi] * rbs;
                bsum += b[yi] * rbs;
                if (i > 0) {
                    rinsum += sir[0];
                    ginsum += sir[1];
                    binsum += sir[2];
                } else {
                    routsum += sir[0];
                    goutsum += sir[1];
                    boutsum += sir[2];
                }
                if (i >= hm) continue;
                yp += w;
            }
            yi = x;
            stackpointer = radius;
            for (y = 0; y < h; ++y) {
                pix[yi] = 0xFF000000 & pix[yi] | dv[rsum] << 16 | dv[gsum] << 8 | dv[bsum];
                rsum -= routsum;
                gsum -= goutsum;
                bsum -= boutsum;
                stackstart = stackpointer - radius + div;
                sir = stack[stackstart % div];
                routsum -= sir[0];
                goutsum -= sir[1];
                boutsum -= sir[2];
                if (x == 0) {
                    vmin[y] = Math.min(y + r1, hm) * w;
                }
                p = x + vmin[y];
                sir[0] = r[p];
                sir[1] = g[p];
                sir[2] = b[p];
                rsum += (rinsum += sir[0]);
                gsum += (ginsum += sir[1]);
                bsum += (binsum += sir[2]);
                stackpointer = (stackpointer + 1) % div;
                sir = stack[stackpointer];
                routsum += sir[0];
                goutsum += sir[1];
                boutsum += sir[2];
                rinsum -= sir[0];
                ginsum -= sir[1];
                binsum -= sir[2];
                yi += w;
            }
        }
        processedBitmap.setPixels(pix, 0, w, 0, 0, w, h);
        return processedBitmap;
    }
}

