/*
 * Decompiled with CFR 0.152.
 */
package com.truebanana.app;

import android.annotation.TargetApi;
import android.app.Activity;
import android.app.ActivityManager;
import android.app.AppOpsManager;
import android.content.ActivityNotFoundException;
import android.content.Context;
import android.content.Intent;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.content.pm.Signature;
import android.net.Uri;
import android.os.Process;
import android.support.v4.app.ActivityCompat;
import android.support.v4.content.ContextCompat;
import android.util.Base64;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.List;

public class AppUtils {
    public static int getVersionCode(Context context, String packageName) {
        try {
            return context.getPackageManager().getPackageInfo((String)packageName, (int)0).versionCode;
        }
        catch (PackageManager.NameNotFoundException e) {
            return 0;
        }
    }

    public static int getVersionCode(Context context) {
        return AppUtils.getVersionCode(context, context.getPackageName());
    }

    public static String getVersionName(Context context, String packageName) {
        try {
            return context.getPackageManager().getPackageInfo((String)packageName, (int)0).versionName;
        }
        catch (PackageManager.NameNotFoundException e) {
            return null;
        }
    }

    public static String getVersionName(Context context) {
        return AppUtils.getVersionName(context, context.getPackageName());
    }

    public static boolean launchApp(Context context, String packageName) {
        PackageManager packageManager = context.getPackageManager();
        Intent intent = packageManager.getLaunchIntentForPackage(packageName);
        if (intent != null) {
            context.startActivity(intent);
            return true;
        }
        return false;
    }

    public static Boolean isRunning(Context context, String packageName) {
        ActivityManager activityManager = (ActivityManager)context.getSystemService("activity");
        List processInfo = activityManager.getRunningAppProcesses();
        for (int i = 0; i < processInfo.size(); ++i) {
            if (!((ActivityManager.RunningAppProcessInfo)processInfo.get((int)i)).processName.equals(packageName)) continue;
            return true;
        }
        return false;
    }

    public static boolean isInstalled(Context context, String packageName) {
        PackageManager packageManager = context.getPackageManager();
        try {
            packageManager.getPackageInfo(packageName, 1);
            return true;
        }
        catch (PackageManager.NameNotFoundException e) {
            return false;
        }
    }

    public static boolean isInstalledFromPlayStore(Context context, String packageName) {
        String installer = AppUtils.getInstallerPackageName(context, packageName);
        return installer != null && installer.equals("com.android.vending");
    }

    public static boolean isInstalledFromPlayStore(Context context) {
        return AppUtils.isInstalledFromPlayStore(context, context.getPackageName());
    }

    public static String getInstallerPackageName(Context context, String packageName) {
        PackageManager packageManager = context.getPackageManager();
        try {
            ApplicationInfo applicationInfo = packageManager.getApplicationInfo(packageName, 0);
            return packageManager.getInstallerPackageName(applicationInfo.packageName);
        }
        catch (PackageManager.NameNotFoundException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static String getInstallerPackageName(Context context) {
        return AppUtils.getInstallerPackageName(context, context.getPackageName());
    }

    public static void launchPlayStoreProductPage(Context context, String packageName) {
        Intent intent = new Intent("android.intent.action.VIEW");
        try {
            intent.setData(Uri.parse((String)("market://details?id=" + packageName)));
            context.startActivity(intent);
        }
        catch (ActivityNotFoundException e) {
            intent.setData(Uri.parse((String)("http://play.google.com/store/apps/details?id=" + packageName)));
            context.startActivity(intent);
        }
    }

    public static void launchPlayStoreProductPage(Context context) {
        AppUtils.launchPlayStoreProductPage(context, context.getPackageName());
    }

    public static String getPlayStoreProductPageURL(String packageName) {
        return "http://play.google.com/store/apps/details?id=" + packageName;
    }

    public static String getPlayStoreProductPageURL(Context context) {
        return AppUtils.getPlayStoreProductPageURL(context.getPackageName());
    }

    public static boolean isPermissionGranted(Context context, String permission) {
        return ContextCompat.checkSelfPermission((Context)context, (String)permission) == 0;
    }

    public static boolean shouldShowRequestPermissionRationale(Activity activity, String permission) {
        return ActivityCompat.shouldShowRequestPermissionRationale((Activity)activity, (String)permission);
    }

    public static void requestPermissions(Activity activity, String[] permissions, int requestCode) {
        ActivityCompat.requestPermissions((Activity)activity, (String[])permissions, (int)requestCode);
    }

    @TargetApi(value=19)
    public static boolean isAppOpsAllowed(Context context, String appOpsPermission) {
        AppOpsManager aom = (AppOpsManager)context.getSystemService("appops");
        return aom.checkOpNoThrow(appOpsPermission, Process.myUid(), context.getPackageName()) == 0;
    }

    public static List<String> getKeyHashes(Context context, String packageName) {
        try {
            ArrayList<String> hashes = new ArrayList<String>();
            PackageInfo info = context.getPackageManager().getPackageInfo(packageName, 64);
            for (Signature signature : info.signatures) {
                MessageDigest md = MessageDigest.getInstance("SHA");
                md.update(signature.toByteArray());
                hashes.add(Base64.encodeToString((byte[])md.digest(), (int)0));
            }
            return hashes;
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            // empty catch block
        }
        return null;
    }

    public static String getKeyHash(Context context, String packageName) {
        try {
            PackageInfo info = context.getPackageManager().getPackageInfo(packageName, 64);
            MessageDigest md = MessageDigest.getInstance("SHA");
            md.update(info.signatures[0].toByteArray());
            return Base64.encodeToString((byte[])md.digest(), (int)0);
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            // empty catch block
        }
        return null;
    }

    public static List<String> getKeyHashes(Context context) {
        return AppUtils.getKeyHashes(context, context.getPackageName());
    }

    public static String getKeyHash(Context context) {
        return AppUtils.getKeyHash(context, context.getPackageName());
    }

    public static boolean launchURI(Context context, String uri) {
        Intent intent = new Intent("android.intent.action.VIEW", Uri.parse((String)uri));
        try {
            context.startActivity(intent);
            return true;
        }
        catch (ActivityNotFoundException e) {
            return false;
        }
    }
}

