/*
 * Decompiled with CFR 0.152.
 */
package com.truebanana.http;

import com.truebanana.http.HTTPResponse;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.json.JSONObject;

public class MockResponse
extends HTTPResponse {
    private MockResponse() {
    }

    public static class Builder {
        private byte[] content = new byte[0];
        private String stringContent;
        private int statusCode = 200;
        private Map<String, String> headers = Collections.EMPTY_MAP;

        public Builder setContent(byte[] content) {
            this.content = content;
            return this;
        }

        public Builder setContent(String content) {
            this.stringContent = content;
            return this;
        }

        public Builder setContent(JSONObject content) {
            this.stringContent = content.toString();
            return this;
        }

        public Builder setContent(InputStream content) {
            if (content != null) {
                try {
                    int nRead;
                    ByteArrayOutputStream buffer = new ByteArrayOutputStream();
                    byte[] data = new byte[16384];
                    while ((nRead = content.read(data, 0, data.length)) != -1) {
                        buffer.write(data, 0, nRead);
                    }
                    buffer.flush();
                    this.content = buffer.toByteArray();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            return this;
        }

        public Builder setStatusCode(int statusCode) {
            this.statusCode = statusCode;
            return this;
        }

        public Builder addHeader(String key, String value) {
            this.headers.put(key, value);
            return this;
        }

        public Builder addHeaders(Map<String, String> headers) {
            headers.putAll(headers);
            return this;
        }

        public Builder setHeaders(Map<String, String> headers) {
            this.headers = headers;
            return this;
        }

        public MockResponse build() {
            MockResponse response = new MockResponse();
            if (this.stringContent != null) {
                response.content = this.stringContent.getBytes();
                response.stringContent = this.stringContent;
            } else {
                response.content = this.content;
                response.stringContent = new String(this.content);
            }
            response.statusCode = this.statusCode;
            response.responseMessage = this.statusCode + " MOCK RESPONSE";
            response.headers = new HashMap();
            for (Map.Entry<String, String> pair : this.headers.entrySet()) {
                response.headers.put(pair.getKey(), Arrays.asList(pair.getValue()));
            }
            return response;
        }
    }
}

