/*
 * Decompiled with CFR 0.152.
 */
package net.mediavrog.irr;

import android.content.Context;
import java.util.ArrayList;
import java.util.List;
import net.mediavrog.irr.AppStartRule;
import net.mediavrog.irr.DaysUsedRule;
import net.mediavrog.irr.DefaultOnUserActionListener;
import net.mediavrog.irr.DefaultPreferenceProvider;
import net.mediavrog.irr.DidRateRule;
import net.mediavrog.irr.DismissPostponeRule;
import net.mediavrog.irr.DismissRule;
import net.mediavrog.irr.DismissalCountRule;
import net.mediavrog.irr.IrrLayout;
import net.mediavrog.irr.PreferenceValue;
import net.mediavrog.ruli.Rule;
import net.mediavrog.ruli.RuleEngine;
import net.mediavrog.ruli.RuleSet;

public class DefaultRuleEngine
extends RuleEngine {
    public static final int DEFAULT_APP_START_COUNT = 10;
    public static final int DEFAULT_DISTINCT_DAYS = 3;
    public static final int DEFAULT_POSTPONE_DAYS = 6;
    public static final int DEFAULT_MAX_DISMISS_COUNT = 3;
    static final String DEFAULT_DATE_FORMAT = "yyyy-MM-dd";
    private final PreferenceValue.PreferenceProvider preferenceProvider;
    private IrrLayout.OnUserActionListener mListener;

    public static DefaultRuleEngine newInstance(Context ctx, int appStartCount, int distinctDays, int postponeDays, int maxDismissCount) {
        DefaultPreferenceProvider pp = new DefaultPreferenceProvider(ctx);
        RuleSet rule = new RuleSet.Builder().addRule((Rule)new DidRateRule(pp)).addRule((Rule)new AppStartRule(pp, appStartCount)).addRule((Rule)new DaysUsedRule(pp, distinctDays)).addRule((Rule)new DismissalCountRule(pp, maxDismissCount)).addRule((Rule)new DismissPostponeRule(pp, postponeDays)).build();
        ArrayList<Rule> rules = new ArrayList<Rule>();
        rules.add((Rule)rule);
        return new DefaultRuleEngine(pp, rules);
    }

    private DefaultRuleEngine(PreferenceValue.PreferenceProvider pp, List<Rule> rules) {
        super(rules);
        this.preferenceProvider = pp;
    }

    public IrrLayout.OnUserActionListener getListener() {
        if (this.mListener == null) {
            this.mListener = new DefaultOnUserActionListener();
        }
        return this.mListener;
    }

    public void setListener(IrrLayout.OnUserActionListener l) {
        this.mListener = l;
    }

    public void trackAppStart() {
        AppStartRule.trackAppStart(this.preferenceProvider);
    }

    public void trackDismissal() {
        DismissRule.trackDismissal(this.preferenceProvider);
    }

    public void trackRated() {
        DidRateRule.trackRated(this.preferenceProvider);
    }

    public void reset() {
        DefaultRuleEngine.reset(this.preferenceProvider);
    }

    public String toString(boolean evaluate) {
        return "DefaultRuleEngine\n" + super.toString(evaluate);
    }

    public static void reset(Context ctx) {
        DefaultRuleEngine.reset(new DefaultPreferenceProvider(ctx));
    }

    public static void reset(PreferenceValue.PreferenceProvider preferenceProvider) {
        preferenceProvider.getPreferences().edit().clear().apply();
    }
}

