/*
 * Decompiled with CFR 0.152.
 */
package net.mediavrog.irr;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.net.Uri;
import net.mediavrog.irr.DidRateRule;
import net.mediavrog.irr.DismissRule;
import net.mediavrog.irr.IrrLayout;

public class DefaultOnUserActionListener
implements IrrLayout.OnUserActionListener {
    public static int RATE_REQUEST = 7650;
    public static int FEEDBACK_REQUEST = 7651;
    private String mRatingUrl;
    private String mFeedbackUrl;

    public DefaultOnUserActionListener() {
        this(null, null);
    }

    public DefaultOnUserActionListener(String rateUrl, String feedbackUrl) {
        this.mRatingUrl = rateUrl;
        this.mFeedbackUrl = feedbackUrl;
    }

    @Override
    public void onRate(Context ctx) {
        if (this.mRatingUrl == null) {
            this.mRatingUrl = this.getDefaultRatingUrl(ctx);
        }
        if (this.mRatingUrl != null) {
            this.startViewIntent(ctx, this.mRatingUrl, RATE_REQUEST);
        }
        DidRateRule.trackRated(ctx);
    }

    @Override
    public void onFeedback(Context ctx) {
        if (this.mFeedbackUrl != null) {
            this.startViewIntent(ctx, this.mFeedbackUrl, FEEDBACK_REQUEST);
        }
    }

    @Override
    public void onDismiss(Context ctx, IrrLayout.State s) {
        if (s == IrrLayout.State.NUDGE) {
            DismissRule.trackDismissal(ctx);
        }
    }

    String getDefaultRatingUrl(Context ctx) {
        return "https://play.google.com/store/apps/details?id=" + ctx.getPackageName();
    }

    private void startViewIntent(Context ctx, String uri, int requestCode) {
        Intent i = new Intent("android.intent.action.VIEW", Uri.parse((String)uri));
        if (ctx instanceof Activity) {
            ((Activity)ctx).startActivityForResult(i, requestCode);
        } else {
            ctx.startActivity(i);
        }
    }
}

