/*
 * Decompiled with CFR 0.152.
 */
package net.mediavrog.irr;

import android.content.Context;
import android.content.SharedPreferences;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import net.mediavrog.irr.DefaultRuleEngine;
import net.mediavrog.ruli.SimpleRule;
import net.mediavrog.ruli.Value;

public abstract class DismissRule<T extends Comparable<T>>
extends SimpleRule<T> {
    static final String PREF_KEY_DISMISSAL_COUNT = "dismissCount";
    static final String PREF_KEY_LAST_DISMISSED_AT = "lastDismissedAt";

    DismissRule(T lhs, SimpleRule.Comparator c, T rhs) {
        super(lhs, c, rhs);
    }

    DismissRule(Value<T> lhs, SimpleRule.Comparator c, T rhs) {
        super(lhs, c, rhs);
    }

    DismissRule(T lhs, SimpleRule.Comparator c, Value<T> rhs) {
        super(lhs, c, rhs);
    }

    DismissRule(Value<T> lhs, SimpleRule.Comparator c, Value<T> rhs) {
        super(lhs, c, rhs);
    }

    public static void trackDismissal(Context ctx) {
        SharedPreferences s = DefaultRuleEngine.getPreferences(ctx);
        int dismissalCount = s.getInt(PREF_KEY_DISMISSAL_COUNT, 0) + 1;
        String today = new SimpleDateFormat("yyyy-MM-dd", Locale.getDefault()).format(new Date());
        s.edit().putInt(PREF_KEY_DISMISSAL_COUNT, dismissalCount).putString(PREF_KEY_LAST_DISMISSED_AT, today).apply();
    }
}

