/*
 * Decompiled with CFR 0.152.
 */
package net.mediavrog.irr;

import android.content.Context;
import android.content.SharedPreferences;
import java.util.ArrayList;
import java.util.List;
import net.mediavrog.irr.AppStartRule;
import net.mediavrog.irr.DaysUsedRule;
import net.mediavrog.irr.DefaultOnUserActionListener;
import net.mediavrog.irr.DidRateRule;
import net.mediavrog.irr.DismissPostponeRule;
import net.mediavrog.irr.DismissRule;
import net.mediavrog.irr.DismissalCountRule;
import net.mediavrog.irr.IrrLayout;
import net.mediavrog.irr.PreferenceValue;
import net.mediavrog.ruli.Rule;
import net.mediavrog.ruli.RuleEngine;
import net.mediavrog.ruli.RuleSet;

public class DefaultRuleEngine
extends RuleEngine {
    public static final int DEFAULT_APP_START_COUNT = 10;
    public static final int DEFAULT_DISTINCT_DAYS = 3;
    public static final int DEFAULT_POSTPONE_DAYS = 6;
    public static final int DEFAULT_MAX_DISMISS_COUNT = 3;
    private static final String PREF_FILE_NAME_SUFFIX = ".irr_default_rule_engine";
    public static final String DEFAULT_DATE_FORMAT = "yyyy-MM-dd";
    private static SharedPreferences sPrefs;
    private Context mContext;
    private IrrLayout.OnUserActionListener mListener;

    public static DefaultRuleEngine newInstance(final Context ctx, int appStartCount, int distinctDays, int postponeDays, int maxDismissCount) {
        PreferenceValue.PreferenceProvider pp = new PreferenceValue.PreferenceProvider(){
            SharedPreferences prefs;

            @Override
            public SharedPreferences getPreferences() {
                if (this.prefs == null) {
                    this.prefs = DefaultRuleEngine.getPreferences(ctx);
                }
                return this.prefs;
            }
        };
        RuleSet rule = new RuleSet.Builder().addRule((Rule)new DidRateRule(pp)).addRule((Rule)new AppStartRule(pp, appStartCount)).addRule((Rule)new DaysUsedRule(pp, distinctDays)).addRule((Rule)new DismissalCountRule(pp, maxDismissCount)).addRule((Rule)new DismissPostponeRule(pp, postponeDays)).build();
        ArrayList<Rule> rules = new ArrayList<Rule>();
        rules.add((Rule)rule);
        return new DefaultRuleEngine(ctx, rules);
    }

    public DefaultRuleEngine(Context ctx, List<Rule> rules) {
        super(rules);
        this.mContext = ctx;
    }

    public IrrLayout.OnUserActionListener getListener() {
        if (this.mListener == null) {
            this.mListener = new DefaultOnUserActionListener();
        }
        return this.mListener;
    }

    public void setListener(IrrLayout.OnUserActionListener l) {
        this.mListener = l;
    }

    public String toString(boolean evaluate) {
        return "DefaultRuleEngine\n" + super.toString(evaluate);
    }

    public void reset() {
        DefaultRuleEngine.reset(this.mContext);
    }

    public static void reset(Context ctx) {
        DefaultRuleEngine.getPreferences(ctx).edit().clear().apply();
    }

    public void trackAppStart() {
        AppStartRule.trackAppStart(this.mContext);
    }

    public void trackDismissal() {
        DismissRule.trackDismissal(this.mContext);
    }

    public void trackRated() {
        DidRateRule.trackRated(this.mContext);
    }

    public static SharedPreferences getPreferences(Context ctx) {
        if (sPrefs == null) {
            sPrefs = ctx.getSharedPreferences(DefaultRuleEngine.getPrefFileName(ctx), 0);
        }
        return sPrefs;
    }

    private static String getPrefFileName(Context ctx) {
        return ctx.getPackageName() + PREF_FILE_NAME_SUFFIX;
    }
}

