/*
 * Decompiled with CFR 0.152.
 */
package com.trivago.triava.util;

import com.trivago.triava.util.UnitComponent;
import com.trivago.triava.util.UnitSystem;
import java.text.DecimalFormat;

public class UnitFormatter {
    public static String formatAsUnit(long value, UnitSystem unitSystem, String unitPostfix) {
        return UnitFormatter.formatAsUnit(value, unitSystem, unitPostfix, new DecimalFormat("0.##"));
    }

    public static String formatAsUnit(long value, UnitSystem unitSystem, String unitPostfix, DecimalFormat format) {
        StringBuilder formatedSize = new StringBuilder(12);
        if ((double)value < unitSystem.kiloPrefix().value()) {
            formatedSize.append(value).append(unitSystem.basePrefix().symbol());
        } else if ((double)value < unitSystem.megaPrefix().value()) {
            formatedSize.append(UnitFormatter.formatToDigits(value, unitSystem.kiloPrefix().value(), format)).append(unitSystem.kiloPrefix().symbol());
        } else if ((double)value < unitSystem.gigaPrefix().value()) {
            formatedSize.append(UnitFormatter.formatToDigits(value, unitSystem.megaPrefix().value(), format)).append(unitSystem.megaPrefix().symbol());
        } else {
            formatedSize.append(UnitFormatter.formatToDigits(value, unitSystem.gigaPrefix().value(), format)).append(unitSystem.gigaPrefix().symbol());
        }
        return formatedSize.append(unitPostfix).toString();
    }

    private static String formatToDigits(long value, double base, DecimalFormat format) {
        double roundedValue = (double)value / base;
        return format.format(roundedValue);
    }

    public static String formatAsUnits(long number, UnitSystem unitSystem, String unitPostfix, String separator) {
        UnitComponent comp = new UnitComponent(number, unitSystem);
        int GB = comp.giga();
        int MB = comp.mega();
        int KB = comp.kilo();
        int B = comp.base();
        StringBuilder formatedSize = new StringBuilder(32);
        if (GB > 0) {
            formatedSize.append(GB).append(unitSystem.gigaPrefix().symbol()).append(unitPostfix).append(separator);
        }
        if (MB > 0) {
            formatedSize.append(MB).append(unitSystem.megaPrefix().symbol()).append(unitPostfix).append(separator);
        }
        if (KB > 0) {
            formatedSize.append(KB).append(unitSystem.kiloPrefix().symbol()).append(unitPostfix).append(separator);
        }
        formatedSize.append(B).append(unitSystem.basePrefix().symbol()).append(unitPostfix).append(separator);
        formatedSize.setLength(formatedSize.length() - separator.length());
        return formatedSize.toString();
    }
}

