/*
 * Decompiled with CFR 0.152.
 */
package com.trivago.triava.tcache.storage;

import com.trivago.triava.tcache.TCacheHolder;
import com.trivago.triava.tcache.core.Builder;
import com.trivago.triava.tcache.core.StorageBackend;
import java.lang.reflect.Constructor;
import java.util.concurrent.ConcurrentMap;

public class HighscalelibNonBlockingHashMap<K, V>
implements StorageBackend<K, V> {
    @Override
    public ConcurrentMap<K, TCacheHolder<V>> createMap(Builder<K, V> builder, double evictionMapSizeFactor) {
        try {
            Class<?> cacheClass = Class.forName("org.cliffc.high_scale_lib.NonBlockingHashMap");
            Constructor<?> cons = cacheClass.getDeclaredConstructor(Integer.TYPE);
            double loadFactor = 0.75;
            int requiredMapSize = (int)((double)builder.getMaxElements() / loadFactor) + (int)evictionMapSizeFactor;
            ConcurrentMap inst = (ConcurrentMap)cons.newInstance(requiredMapSize);
            return inst;
        }
        catch (Exception exc) {
            throw new RuntimeException("Cannot create map for HashImplementation=" + (Object)((Object)builder.getHashImplementation()), exc);
        }
    }
}

