/*
 * Decompiled with CFR 0.152.
 */
package com.trivago.triava.tcache.storage;

import com.trivago.triava.tcache.CacheWriteMode;
import com.trivago.triava.tcache.storage.ByteArray;
import com.trivago.triava.tcache.util.Serializing;
import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;
import javax.cache.CacheException;

public class ConcurrentKeyDeserMap<K, V>
implements ConcurrentMap<K, V> {
    final ConcurrentMap<ByteArray, V> backingMap;
    final CacheWriteMode writeMode;

    public ConcurrentKeyDeserMap(ConcurrentMap<ByteArray, V> backingMap, CacheWriteMode writeMode) {
        this.backingMap = backingMap;
        this.writeMode = writeMode;
    }

    @Override
    public int size() {
        return this.backingMap.size();
    }

    @Override
    public boolean isEmpty() {
        return this.backingMap.isEmpty();
    }

    @Override
    public boolean containsKey(Object key) {
        return this.backingMap.containsKey(this.serialize(key));
    }

    @Override
    public boolean containsValue(Object value) {
        return this.backingMap.containsValue(value);
    }

    @Override
    public V get(Object key) {
        return this.backingMap.get(this.serialize(key));
    }

    @Override
    public V put(K key, V value) {
        return this.backingMap.put(this.serialize(key), value);
    }

    @Override
    public V remove(Object key) {
        return this.backingMap.remove(this.serialize(key));
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> m) {
        HashMap<ByteArray, V> map = new HashMap<ByteArray, V>(m.size());
        for (Map.Entry<K, V> entry : m.entrySet()) {
            map.put(this.serialize(entry.getKey()), entry.getValue());
        }
        this.backingMap.putAll(map);
    }

    @Override
    public void clear() {
        this.backingMap.clear();
    }

    @Override
    public Set<K> keySet() {
        HashSet<K> keySet = new HashSet<K>(this.backingMap.size());
        for (ByteArray key : this.backingMap.keySet()) {
            keySet.add(this.deserialize(key));
        }
        return keySet;
    }

    @Override
    public Collection<V> values() {
        return this.backingMap.values();
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        HashMap map = new HashMap(this.backingMap.size());
        for (Map.Entry entry : this.backingMap.entrySet()) {
            map.put(this.deserialize((ByteArray)entry.getKey()), entry.getValue());
        }
        return map.entrySet();
    }

    @Override
    public V putIfAbsent(K key, V value) {
        return this.backingMap.putIfAbsent(this.serialize(key), value);
    }

    @Override
    public boolean remove(Object key, Object value) {
        return this.backingMap.remove(this.serialize(key), value);
    }

    @Override
    public boolean replace(K key, V oldValue, V newValue) {
        return this.backingMap.replace(this.serialize(key), oldValue, newValue);
    }

    @Override
    public V replace(K key, V value) {
        return this.backingMap.replace(this.serialize(key), value);
    }

    private K deserialize(ByteArray key) {
        try {
            Object fromBytearray = Serializing.fromBytearray(key.bytes);
            return (K)fromBytearray;
        }
        catch (IOException | ClassNotFoundException e) {
            throw new CacheException("Cannot deserialize key with length=" + key.bytes.length, (Throwable)e);
        }
    }

    private ByteArray serialize(Object key) {
        if (key == null) {
            throw new NullPointerException("key must not be null");
        }
        try {
            return new ByteArray(Serializing.toBytearray(key));
        }
        catch (IOException e) {
            throw new CacheException("Cannot serialize key class of type: " + key.getClass().getName(), (Throwable)e);
        }
    }
}

