/*
 * Decompiled with CFR 0.152.
 */
package com.trivago.triava.tcache.storage;

import java.util.Arrays;

public class ByteArray {
    final byte[] bytes;
    final int hashCode;

    public ByteArray(byte[] bytes) {
        int step;
        int count;
        this.bytes = bytes;
        if (bytes.length < 32) {
            count = bytes.length;
            step = 1;
        } else {
            count = 32;
            step = Math.min(31, bytes.length / count);
        }
        int prime = 31;
        int result = 1;
        int pos = 0;
        int i = 0;
        while (i < count) {
            result = 31 * result + bytes[pos];
            ++i;
            pos += step;
        }
        this.hashCode = result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof ByteArray)) {
            return false;
        }
        ByteArray other = (ByteArray)obj;
        if (this.hashCode != other.hashCode) {
            return false;
        }
        return Arrays.equals(this.bytes, other.bytes);
    }

    public int hashCode() {
        return this.hashCode;
    }
}

