/*
 * Decompiled with CFR 0.152.
 */
package com.trivago.triava.tcache.statistics;

import java.util.Arrays;

public class SlidingWindowCounter {
    private int slotWidth;
    private int counterWidth;
    private int driftLimitHead;
    private int head = 0;
    private int[] slots;
    private long timePointer = 0L;

    public SlidingWindowCounter(int slotCount, int slotWidth) {
        this.slotWidth = slotWidth;
        this.slots = new int[slotCount];
        this.counterWidth = this.slotWidth * slotCount;
        this.driftLimitHead = -1 * this.counterWidth / 2;
    }

    public void registerEvents(long timestampInSeconds, int countOfEvents) {
        int diff;
        if (this.timePointer == 0L) {
            this.timePointer = timestampInSeconds + (long)this.slotWidth;
            this.head = 0;
        }
        if ((diff = this.secondsBetween(timestampInSeconds, this.timePointer)) < 0) {
            if ((diff = -1 * diff) > this.counterWidth) {
                return;
            }
            this.registerEventBeforeTimeBorder(diff, countOfEvents);
        } else {
            this.registerEventAfterTimeBorder(diff, countOfEvents);
        }
    }

    private int secondsBetween(long timePointA, long timePointB) {
        return (int)(timePointA - timePointB);
    }

    private void registerEventBeforeTimeBorder(int diffInSeconds, int countOfEvents) {
        int slotToRegister;
        int deltaSlots = diffInSeconds / this.slotWidth;
        if (diffInSeconds % this.slotWidth == 0) {
            --deltaSlots;
        }
        if ((slotToRegister = this.head - deltaSlots) < 0) {
            slotToRegister = this.slots.length + slotToRegister;
        }
        this.slots[slotToRegister] = this.slots[slotToRegister] + countOfEvents;
    }

    private void registerEventAfterTimeBorder(int diffInSeconds, int countOfEvents) {
        this.moveHeadForward(diffInSeconds);
        this.slots[this.head] = countOfEvents;
    }

    private void moveHeadForward(int diffInSeconds) {
        int deltaSlots = 0;
        if (diffInSeconds == 0) {
            deltaSlots = 1;
        } else {
            deltaSlots = diffInSeconds / this.slotWidth;
            if (diffInSeconds % this.slotWidth != 0) {
                ++deltaSlots;
            }
        }
        for (int i = 0; i < deltaSlots; ++i) {
            this.head = (this.head + 1) % this.slots.length;
            this.slots[this.head] = 0;
            this.timePointer += (long)this.slotWidth;
        }
    }

    public int getRateTotal(long timeNowInSeconds) {
        this.synchronizeTimePointer(timeNowInSeconds);
        return this.getRateTotal();
    }

    public int getRateTotal() {
        int rate = 0;
        for (int i = 0; i < this.slots.length; ++i) {
            int nextSlot = this.head - i;
            if (nextSlot < 0) {
                nextSlot = this.slots.length + nextSlot;
            }
            rate += this.slots[nextSlot];
        }
        return rate;
    }

    public void synchronizeTimePointer(long timeNowInSeconds) {
        int diffInSeconds;
        if (this.timePointer > 0L && (diffInSeconds = this.secondsBetween(this.timePointer, timeNowInSeconds)) < this.driftLimitHead) {
            diffInSeconds = -1 * diffInSeconds;
            this.moveHeadForward(diffInSeconds);
        }
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append('(');
        for (int i = 0; i < this.slots.length; ++i) {
            int slotValue = this.slots[i];
            if (i == this.head) {
                builder.append('[');
            }
            builder.append(slotValue);
            if (i == this.head) {
                builder.append(']');
            }
            builder.append(',');
        }
        builder.replace(builder.length() - 1, builder.length(), ") / ");
        builder.append(this.getRateTotal());
        builder.append(" / ");
        builder.append(this.timePointer);
        return builder.toString();
    }

    public int[] getCopyOfSlots() {
        return Arrays.copyOf(this.slots, this.slots.length);
    }
}

