/*
 * Decompiled with CFR 0.152.
 */
package com.trivago.triava.tcache.core;

import com.trivago.triava.tcache.core.TCacheJSR107Entry;
import javax.cache.integration.CacheLoader;
import javax.cache.processor.MutableEntry;

public final class TCacheJSR107MutableEntry<K, V>
extends TCacheJSR107Entry<K, V>
implements MutableEntry<K, V> {
    private Operation operation = Operation.NOP;
    V valueNew = null;
    final CacheLoader<K, V> loader;

    public TCacheJSR107MutableEntry(K key, V value, CacheLoader<K, V> loader) {
        super(key, value);
        this.valueNew = value;
        this.loader = loader;
    }

    public boolean exists() {
        return this.valueNew != null;
    }

    public void remove() {
        this.operation = this.operation == Operation.SET || this.operation == Operation.LOAD ? Operation.NOP : (this.oldValue() != null ? Operation.REMOVE : (this.valueNew != null ? Operation.NOP : Operation.REMOVE_WRITE_THROUGH));
        this.valueNew = null;
    }

    @Override
    public V getValue() {
        if (this.valueNew == null && this.loader != null) {
            this.valueNew = this.loader.load(this.key);
            this.operation = Operation.LOAD;
        }
        if (this.operation == Operation.NOP) {
            this.operation = Operation.GET;
        }
        return this.valueNew;
    }

    public void setValue(V value) {
        if (value == null) {
            throw new NullPointerException("value is null in setValue()");
        }
        this.operation = Operation.SET;
        this.valueNew = value;
    }

    private V oldValue() {
        return (V)this.value;
    }

    public Operation operation() {
        return this.operation;
    }

    public static enum Operation {
        NOP,
        REMOVE,
        SET,
        LOAD,
        REMOVE_WRITE_THROUGH,
        GET;

    }
}

