/*
 * Decompiled with CFR 0.152.
 */
package com.trivago.triava.tcache.core;

import com.trivago.triava.annotations.Beta;
import com.trivago.triava.tcache.Cache;
import com.trivago.triava.tcache.CacheWriteMode;
import com.trivago.triava.tcache.EvictionPolicy;
import com.trivago.triava.tcache.HashImplementation;
import com.trivago.triava.tcache.JamPolicy;
import com.trivago.triava.tcache.core.CacheLoader;
import com.trivago.triava.tcache.core.StorageBackend;
import com.trivago.triava.tcache.core.TriavaCacheConfiguration;
import com.trivago.triava.tcache.eviction.EvictionInterface;
import com.trivago.triava.tcache.storage.HighscalelibNonBlockingHashMap;
import com.trivago.triava.tcache.storage.JavaConcurrentHashMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Properties;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import javax.cache.configuration.CacheEntryListenerConfiguration;
import javax.cache.configuration.CompleteConfiguration;
import javax.cache.configuration.Configuration;
import javax.cache.configuration.Factory;
import javax.cache.configuration.FactoryBuilder;
import javax.cache.expiry.Duration;
import javax.cache.expiry.EternalExpiryPolicy;
import javax.cache.expiry.ExpiryPolicy;
import javax.cache.expiry.TouchedExpiryPolicy;
import javax.cache.integration.CacheWriter;

public class Builder<K, V>
implements TriavaCacheConfiguration<K, V, Builder<K, V>> {
    private static final long serialVersionUID = -4430382287782891844L;
    static final AtomicInteger anonymousCacheId = new AtomicInteger();
    private String id;
    private boolean strictJSR107 = true;
    private long maxCacheTime = 3600000L;
    private long maxCacheTimeSpread = 0L;
    private int expectedMapSize = 10000;
    private int concurrencyLevel = 14;
    private int mapConcurrencyLevel = 16;
    private long cleanUpIntervalMillis = 0L;
    private EvictionPolicy evictionPolicy = EvictionPolicy.LFU;
    private EvictionInterface<K, V> evictionClass = null;
    private HashImplementation hashImplementation = HashImplementation.ConcurrentHashMap;
    private JamPolicy jamPolicy = JamPolicy.WAIT;
    private boolean statistics = false;
    private boolean management = false;
    private CacheWriteMode writeMode = CacheWriteMode.Identity;
    private Class<K> keyType = this.objectKeyType();
    private Class<V> valueType = this.objectValueType();
    private Collection<CacheEntryListenerConfiguration<K, V>> listenerConfigurations = new ArrayList<CacheEntryListenerConfiguration<K, V>>(0);
    private Factory<CacheWriter<? super K, ? super V>> writerFactory = null;
    private Factory<ExpiryPolicy> expiryPolicyFactory = EternalExpiryPolicy.factoryOf();
    private CacheLoader<K, V> loader = null;
    private Factory<javax.cache.integration.CacheLoader<K, V>> loaderFactory = null;
    private boolean writeThrough = false;
    private boolean readThrough = false;

    public Builder() {
        this.management = true;
        this.statistics = true;
        this.strictJSR107 = false;
    }

    public Builder(Configuration<K, V> configuration) {
        this.writeMode = null;
        this.maxCacheTime = Long.MAX_VALUE;
        this.copyBuilder(configuration, this);
    }

    public Cache<K, V> build() {
        throw new UnsupportedOperationException("build() is only supported by internal subclasses.");
    }

    static <Arg> Arg verifyNotNull(String name, Arg arg) {
        if (arg == null) {
            throw new IllegalArgumentException(name + " is null");
        }
        return arg;
    }

    @Override
    public Builder<K, V> setId(String id) {
        this.id = id;
        return this;
    }

    @Override
    public Builder<K, V> setMaxIdleTime(int maxIdleTime, TimeUnit timeUnit) {
        FactoryBuilder.SingletonFactory singletonFactory;
        if (maxIdleTime <= 0) {
            throw new IllegalArgumentException("Invalid maxIdleTime: " + maxIdleTime);
        }
        TouchedExpiryPolicy ep = new TouchedExpiryPolicy(new Duration(timeUnit, (long)maxIdleTime));
        this.expiryPolicyFactory = singletonFactory = new FactoryBuilder.SingletonFactory((Object)ep);
        return this;
    }

    @Override
    public Builder<K, V> setMaxCacheTime(int maxCacheTime, int interval, TimeUnit timeUnit) {
        if (interval <= 0) {
            throw new IllegalArgumentException("Invalid interval: " + interval);
        }
        this.setMaxCacheTime(maxCacheTime, timeUnit);
        this.maxCacheTimeSpread = timeUnit.toMillis(interval);
        return this;
    }

    @Override
    public Builder<K, V> setMaxCacheTime(int maxCacheTime, TimeUnit timeUnit) {
        if (maxCacheTime <= 0) {
            throw new IllegalArgumentException("Invalid maxCacheTime: " + maxCacheTime);
        }
        this.maxCacheTime = timeUnit.toMillis(maxCacheTime);
        return this;
    }

    @Override
    public Builder<K, V> setCleanupInterval(int cleanupInterval, TimeUnit timeUnit) {
        this.cleanUpIntervalMillis = timeUnit.toMillis(cleanupInterval);
        return this;
    }

    public Builder<K, V> setExpectedMapSize(int maxElements) {
        return this.setMaxElements(maxElements);
    }

    @Override
    public Builder<K, V> setMaxElements(int maxElements) {
        if (maxElements < 0) {
            throw new IllegalArgumentException("Invalid expectedMapSize: " + this.expectedMapSize);
        }
        this.expectedMapSize = maxElements;
        return this;
    }

    @Override
    public Builder<K, V> setConcurrencyLevel(int concurrencyLevel) {
        this.concurrencyLevel = concurrencyLevel;
        this.mapConcurrencyLevel = Math.max(concurrencyLevel + 2, 8);
        return this;
    }

    @Override
    public Builder<K, V> setEvictionPolicy(EvictionPolicy evictionPolicy) {
        this.evictionPolicy = evictionPolicy;
        this.evictionClass = null;
        return this;
    }

    @Override
    public Builder<K, V> setEvictionClass(EvictionInterface<K, V> clazz) {
        this.evictionPolicy = EvictionPolicy.CUSTOM;
        this.evictionClass = clazz;
        return this;
    }

    @Override
    public EvictionInterface<K, V> getEvictionClass() {
        return this.evictionClass;
    }

    @Override
    @Beta(comment="To be replaced by a method to set a StorageBackend")
    public Builder<K, V> setHashImplementation(HashImplementation hashImplementation) {
        this.hashImplementation = hashImplementation;
        return this;
    }

    @Override
    public Builder<K, V> setJamPolicy(JamPolicy jamPolicy) {
        this.jamPolicy = jamPolicy;
        return this;
    }

    @Override
    public boolean getStatistics() {
        return this.statistics;
    }

    @Override
    public Builder<K, V> setStatistics(boolean statistics) {
        this.statistics = statistics;
        return this;
    }

    @Override
    public Builder<K, V> setManagement(boolean management) {
        this.management = management;
        return this;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public long getMaxIdleTime() {
        Duration accessExpiry = ((ExpiryPolicy)this.expiryPolicyFactory.create()).getExpiryForAccess();
        return accessExpiry.getAdjustedTime(0L);
    }

    @Override
    public long getMaxCacheTime() {
        return this.maxCacheTime;
    }

    @Override
    public long getMaxCacheTimeSpread() {
        return this.maxCacheTimeSpread;
    }

    @Override
    public long getCleanUpIntervalMillis() {
        return this.cleanUpIntervalMillis;
    }

    @Override
    public int getMaxElements() {
        return this.expectedMapSize;
    }

    @Override
    public int getConcurrencyLevel() {
        return this.concurrencyLevel;
    }

    @Override
    public int getMapConcurrencyLevel() {
        return this.mapConcurrencyLevel;
    }

    @Override
    public EvictionPolicy getEvictionPolicy() {
        return this.evictionPolicy;
    }

    @Override
    public HashImplementation getHashImplementation() {
        return this.hashImplementation;
    }

    @Override
    public StorageBackend<K, V> storageFactory() {
        switch (this.hashImplementation) {
            case ConcurrentHashMap: {
                return new JavaConcurrentHashMap();
            }
            case HighscalelibNonBlockingHashMap: {
                return new HighscalelibNonBlockingHashMap();
            }
        }
        return null;
    }

    @Override
    public JamPolicy getJamPolicy() {
        return this.jamPolicy;
    }

    @Override
    public CacheLoader<K, V> getLoader() {
        return this.loader;
    }

    @Override
    public Builder<K, V> setLoader(CacheLoader<K, V> loader) {
        this.loader = loader;
        return this;
    }

    @Override
    public Factory<javax.cache.integration.CacheLoader<K, V>> getCacheLoaderFactory() {
        return this.loaderFactory;
    }

    @Override
    public Class<K> getKeyType() {
        return this.keyType == null ? Object.class : this.keyType;
    }

    @Override
    public Class<V> getValueType() {
        return this.valueType;
    }

    @Override
    public void setKeyType(Class<K> keyType) {
        this.keyType = keyType;
    }

    @Override
    public void setValueType(Class<V> valueType) {
        this.valueType = valueType;
    }

    @Override
    public boolean isStoreByValue() {
        return this.writeMode.isStoreByValue();
    }

    @Override
    public CacheWriteMode getCacheWriteMode() {
        return this.writeMode;
    }

    @Override
    public Builder<K, V> setCacheWriteMode(CacheWriteMode writeMode) {
        this.writeMode = writeMode;
        return this;
    }

    @Override
    public Properties asProperties(TriavaCacheConfiguration.PropsType propsType) {
        boolean propsForCache = propsType == TriavaCacheConfiguration.PropsType.Cache;
        Properties props = new Properties();
        if (propsForCache) {
            props.setProperty("cacheName", this.id);
        }
        props.setProperty("maxIdleTime", Long.toString(this.getMaxIdleTime()));
        props.setProperty("maxCacheTime", Long.toString(this.maxCacheTime));
        props.setProperty("maxCacheTimeSpread", Long.toString(this.maxCacheTimeSpread));
        props.setProperty("expectedMapSize", Integer.toString(this.expectedMapSize));
        props.setProperty("concurrencyLevel", Integer.toString(this.concurrencyLevel));
        props.setProperty("evictionPolicy", this.evictionPolicy.toString());
        props.setProperty("hashMapClass", this.hashImplementation.toString());
        props.setProperty("jamPolicy", this.jamPolicy.toString());
        props.setProperty("statistics", Boolean.toString(this.statistics));
        if (propsForCache) {
            props.setProperty("cacheLoaderClass", this.loader == null ? "null" : this.loader.getClass().getName());
        }
        props.setProperty("writeMode", this.writeMode.toString());
        return props;
    }

    private void copyBuilder(Configuration<K, V> configuration, Builder<K, V> target) {
        CacheWriteMode tcacheWriteMode = null;
        if (configuration instanceof Builder) {
            Builder sourceB = (Builder)configuration;
            if (sourceB.id != null) {
                target.id = sourceB.id;
            }
            target.strictJSR107 = sourceB.strictJSR107;
            target.maxCacheTime = sourceB.maxCacheTime;
            target.maxCacheTimeSpread = sourceB.maxCacheTimeSpread;
            this.cleanUpIntervalMillis = sourceB.cleanUpIntervalMillis;
            target.expectedMapSize = sourceB.expectedMapSize;
            target.concurrencyLevel = sourceB.concurrencyLevel;
            if (sourceB.evictionPolicy != null) {
                target.evictionPolicy = sourceB.evictionPolicy;
            }
            if (sourceB.evictionClass != null) {
                target.evictionClass = sourceB.evictionClass;
            }
            if (sourceB.hashImplementation != null) {
                target.hashImplementation = sourceB.hashImplementation;
            }
            if (sourceB.jamPolicy != null) {
                target.jamPolicy = sourceB.jamPolicy;
            }
            if (sourceB.loader != null) {
                target.loader = sourceB.loader;
            }
            tcacheWriteMode = sourceB.writeMode;
        }
        if (configuration instanceof CompleteConfiguration) {
            CompleteConfiguration cc = (CompleteConfiguration)configuration;
            target.statistics = cc.isStatisticsEnabled();
            target.management = cc.isManagementEnabled();
            target.expiryPolicyFactory = cc.getExpiryPolicyFactory();
            target.writerFactory = cc.getCacheWriterFactory();
            Factory lf = cc.getCacheLoaderFactory();
            if (lf != null) {
                target.loader = null;
                target.loaderFactory = lf;
            }
            ArrayList<CacheEntryListenerConfiguration<K, V>> listenerConfsCopy = new ArrayList<CacheEntryListenerConfiguration<K, V>>(0);
            for (CacheEntryListenerConfiguration entry : cc.getCacheEntryListenerConfigurations()) {
                listenerConfsCopy.add(entry);
            }
            target.listenerConfigurations = listenerConfsCopy;
            target.writeThrough = cc.isWriteThrough();
            target.readThrough = cc.isReadThrough();
        }
        target.writeMode = tcacheWriteMode != null ? tcacheWriteMode : CacheWriteMode.fromStoreByValue(configuration.isStoreByValue());
        target.keyType = configuration.getKeyType();
        target.valueType = configuration.getValueType();
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.concurrencyLevel;
        result = 31 * result + (this.evictionClass == null ? 0 : this.evictionClass.hashCode());
        result = 31 * result + (this.evictionPolicy == null ? 0 : this.evictionPolicy.hashCode());
        result = 31 * result + this.expectedMapSize;
        result = 31 * result + (this.hashImplementation == null ? 0 : this.hashImplementation.hashCode());
        result = 31 * result + (this.id == null ? 0 : this.id.hashCode());
        result = 31 * result + (this.jamPolicy == null ? 0 : this.jamPolicy.hashCode());
        result = 31 * result + (this.keyType == null ? 0 : this.keyType.hashCode());
        result = 31 * result + (this.loader == null ? 0 : this.loader.hashCode());
        result = 31 * result + this.mapConcurrencyLevel;
        result = 31 * result + (int)(this.maxCacheTime ^ this.maxCacheTime >>> 32);
        result = 31 * result + (int)(this.maxCacheTimeSpread ^ this.maxCacheTimeSpread >>> 32);
        result = 31 * result + (int)(this.cleanUpIntervalMillis ^ this.cleanUpIntervalMillis >>> 32);
        result = 31 * result + this.expiryPolicyFactory.hashCode();
        result = 31 * result + (this.statistics ? 1231 : 1237);
        result = 31 * result + (this.valueType == null ? 0 : this.valueType.hashCode());
        result = 31 * result + (this.writeMode == null ? 0 : this.writeMode.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        if (!(obj instanceof Builder)) {
            return false;
        }
        Builder other = (Builder)obj;
        if (this.concurrencyLevel != other.concurrencyLevel) {
            return false;
        }
        if (this.evictionClass == null ? other.evictionClass != null : !this.evictionClass.equals(other.evictionClass)) {
            return false;
        }
        if (this.evictionPolicy != other.evictionPolicy) {
            return false;
        }
        if (this.expectedMapSize != other.expectedMapSize) {
            return false;
        }
        if (this.hashImplementation != other.hashImplementation) {
            return false;
        }
        if (this.id == null ? other.id != null : !this.id.equals(other.id)) {
            return false;
        }
        if (this.jamPolicy != other.jamPolicy) {
            return false;
        }
        if (this.keyType == null ? other.keyType != null : !this.keyType.equals(other.keyType)) {
            return false;
        }
        if (this.loader == null ? other.loader != null : !this.loader.equals(other.loader)) {
            return false;
        }
        if (this.mapConcurrencyLevel != other.mapConcurrencyLevel) {
            return false;
        }
        if (this.maxCacheTime != other.maxCacheTime) {
            return false;
        }
        if (this.maxCacheTimeSpread != other.maxCacheTimeSpread) {
            return false;
        }
        if (this.cleanUpIntervalMillis != other.cleanUpIntervalMillis) {
            return false;
        }
        if (!this.expiryPolicyFactory.equals(other.expiryPolicyFactory)) {
            return false;
        }
        if (this.statistics != other.statistics) {
            return false;
        }
        if (this.valueType == null ? other.valueType != null : !this.valueType.equals(other.valueType)) {
            return false;
        }
        return this.writeMode == other.writeMode;
    }

    @Override
    public boolean isReadThrough() {
        return this.readThrough;
    }

    @Override
    public Builder<K, V> setCacheLoaderFactory(Factory<javax.cache.integration.CacheLoader<K, V>> loaderFactory) {
        this.loaderFactory = loaderFactory;
        return this;
    }

    @Override
    public Builder<K, V> setCacheWriterFactory(Factory<? extends CacheWriter<? super K, ? super V>> factory) {
        this.writerFactory = factory;
        return this;
    }

    @Override
    public Builder<K, V> setReadThrough(boolean isReadThrough) {
        this.readThrough = isReadThrough;
        return this;
    }

    @Override
    public Builder<K, V> setWriteThrough(boolean isWriteThrough) {
        this.writeThrough = isWriteThrough;
        return this;
    }

    @Override
    public boolean isWriteThrough() {
        return this.writeThrough;
    }

    @Override
    public boolean isStatisticsEnabled() {
        return this.statistics;
    }

    @Override
    public boolean isManagementEnabled() {
        return this.management;
    }

    @Override
    public boolean isStrictJSR107() {
        return this.strictJSR107;
    }

    @Override
    public void setStrictJSR107(boolean strictJSR107) {
        this.strictJSR107 = strictJSR107;
    }

    @Override
    public Iterable<CacheEntryListenerConfiguration<K, V>> getCacheEntryListenerConfigurations() {
        return this.listenerConfigurations;
    }

    @Override
    public Factory<CacheWriter<? super K, ? super V>> getCacheWriterFactory() {
        return this.writerFactory;
    }

    @Override
    public Factory<ExpiryPolicy> getExpiryPolicyFactory() {
        return this.expiryPolicyFactory;
    }

    @Override
    public Builder<K, V> setExpiryPolicyFactory(Factory<? extends ExpiryPolicy> factory) {
        if (this.expiryPolicyFactory == null) {
            this.expiryPolicyFactory = EternalExpiryPolicy.factoryOf();
        } else {
            Factory<? extends ExpiryPolicy> factoryCasted = factory;
            this.expiryPolicyFactory = factoryCasted;
        }
        return this;
    }

    private Class<V> objectValueType() {
        return Object.class;
    }

    private Class<K> objectKeyType() {
        return Object.class;
    }

    @Override
    public void addCacheEntryListenerConfiguration(CacheEntryListenerConfiguration<K, V> listenerConfiguration) {
        this.listenerConfigurations.add(listenerConfiguration);
    }

    @Override
    public void removeCacheEntryListenerConfiguration(CacheEntryListenerConfiguration<K, V> listenerConfiguration) {
        this.listenerConfigurations.remove(listenerConfiguration);
    }
}

