/*
 * Decompiled with CFR 0.152.
 */
package com.trivago.triava.tcache.action;

import com.trivago.triava.tcache.action.Action;
import com.trivago.triava.tcache.action.ActionRunner;
import com.trivago.triava.tcache.core.TCacheJSR107Entry;
import javax.cache.event.EventType;
import javax.cache.integration.CacheWriterException;

public class PutAction<K, V, W>
extends Action<K, V, W> {
    final boolean countStatistics;
    final boolean writeThrough;

    public PutAction(K key, V value, EventType eventType, boolean countStatistics) {
        super(key, value, eventType);
        this.countStatistics = countStatistics;
        this.writeThrough = true;
    }

    public PutAction(K key, V value, EventType eventType, boolean countStatistics, boolean writeThrough) {
        super(key, value, eventType);
        this.countStatistics = countStatistics;
        this.writeThrough = writeThrough;
    }

    @Override
    W writeThroughImpl(ActionRunner<K, V> actionRunner, Object arg) {
        if (!this.writeThrough) {
            return null;
        }
        try {
            actionRunner.cacheWriter.write(new TCacheJSR107Entry<Object, Object>(this.key, this.value));
        }
        catch (Exception exc) {
            this.writeThroughException = new CacheWriterException((Throwable)exc);
        }
        return null;
    }

    @Override
    void notifyListenersImpl(ActionRunner<K, V> actionRunner, Object arg) {
        if (this.eventType != null) {
            actionRunner.listeners.dispatchEvent(this.eventType, this.key, this.value);
        }
    }

    @Override
    void statisticsImpl(ActionRunner<K, V> actionRunner, Object arg) {
        if (this.countStatistics) {
            actionRunner.stats.incrementPutCount();
        }
    }
}

