/*
 * Decompiled with CFR 0.152.
 */
package com.trivago.triava.tcache;

import com.trivago.triava.tcache.Cache;
import com.trivago.triava.tcache.TCacheJSR107;
import com.trivago.triava.tcache.core.Builder;
import com.trivago.triava.tcache.core.InternalBuilder;
import com.trivago.triava.tcache.core.TCacheProvider;
import com.trivago.triava.tcache.util.CacheSizeInfo;
import com.trivago.triava.tcache.util.ObjectSizeCalculatorInterface;
import java.io.Closeable;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.atomic.AtomicInteger;
import javax.cache.CacheException;
import javax.cache.CacheManager;
import javax.cache.configuration.Configuration;
import javax.cache.spi.CachingProvider;

public class TCacheFactory
implements Closeable,
CacheManager {
    final CopyOnWriteArrayList<Cache<?, ?>> CacheInstances = new CopyOnWriteArrayList();
    final Object factoryLock = new Object();
    boolean closed = false;
    private final URI uri;
    static AtomicInteger uriSeqno = new AtomicInteger();
    final ClassLoader classloader;
    final Properties properties;
    final TCacheProvider cachingProvider;
    static TCacheFactory standardFactory = null;

    public TCacheFactory() {
        this.classloader = Thread.currentThread().getContextClassLoader();
        this.properties = new Properties();
        int seqno = uriSeqno.incrementAndGet();
        String uriString = "tcache:/manager-" + seqno;
        try {
            this.uri = new URI(uriString);
        }
        catch (URISyntaxException e) {
            throw new AssertionError("URI cannot be created: " + uriString, e);
        }
        this.cachingProvider = null;
    }

    public TCacheFactory(URI uri, ClassLoader classLoader, TCacheProvider cachingProvider) {
        this.classloader = classLoader;
        this.uri = uri;
        this.properties = new Properties();
        this.cachingProvider = cachingProvider;
    }

    public TCacheFactory(URI uri, ClassLoader classLoader, Properties properties, TCacheProvider cachingProvider) {
        this.classloader = classLoader;
        this.uri = uri;
        this.properties = new Properties(properties);
        this.cachingProvider = cachingProvider;
    }

    public static synchronized TCacheFactory standardFactory() {
        TCacheFactory sf = standardFactory;
        if (sf == null || sf.isClosed()) {
            standardFactory = sf = new TCacheFactory();
        }
        return sf;
    }

    public <K, V> Builder<K, V> builder() {
        return new InternalBuilder(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerCache(Cache<?, ?> cache) {
        this.assertNotClosed();
        String id = cache.id();
        Object object = this.factoryLock;
        synchronized (object) {
            for (Cache<?, ?> registeredCache : this.CacheInstances) {
                if (!registeredCache.id().equals(id)) continue;
                throw new CacheException("Cache with the same id is already registered: " + id);
            }
            this.CacheInstances.add(cache);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroyCache(String cacheName) {
        this.assertNotClosed();
        if (cacheName == null) {
            throw new NullPointerException("cacheName is null");
        }
        Object object = this.factoryLock;
        synchronized (object) {
            int index = 0;
            for (Cache<?, ?> registeredCache : this.CacheInstances) {
                if (registeredCache.id().equals(cacheName)) {
                    registeredCache.close0(false);
                    this.CacheInstances.remove(index);
                    break;
                }
                ++index;
            }
        }
    }

    public URI getURI() {
        return this.uri;
    }

    public ClassLoader getClassLoader() {
        return this.classloader;
    }

    public Properties getProperties() {
        return this.properties;
    }

    @Override
    public void close() {
        for (Cache<?, ?> cache : this.CacheInstances) {
            cache.close();
        }
        this.CacheInstances.clear();
        if (this.cachingProvider == null) {
            this.closed = true;
        } else {
            this.cachingProvider.removeCacheManager0(this);
            this.closed = true;
        }
    }

    public boolean isClosed() {
        return this.closed;
    }

    public Map<String, CacheSizeInfo> reportAllCacheSizes(ObjectSizeCalculatorInterface objectSizeCalculator) {
        HashMap<String, CacheSizeInfo> infoMap = new HashMap<String, CacheSizeInfo>();
        for (Cache<?, ?> cache : this.CacheInstances) {
            infoMap.put(cache.id(), cache.reportSize(objectSizeCalculator));
        }
        return infoMap;
    }

    public List<Cache<?, ?>> instances() {
        return new ArrayList(this.CacheInstances);
    }

    private void assertNotClosed() {
        if (this.closed) {
            throw new IllegalStateException("CacheManager " + this.uri + " is already closed");
        }
    }

    public <K, V, C extends Configuration<K, V>> javax.cache.Cache<K, V> createCache(String cacheName, C configuration) throws IllegalArgumentException {
        this.assertNotClosed();
        if (cacheName == null) {
            throw new NullPointerException("cacheName is null");
        }
        InternalBuilder builder = new InternalBuilder(this, configuration);
        builder.setId(cacheName);
        Cache tcache = builder.build();
        return tcache.jsr107cache();
    }

    public void enableManagement(String cacheName, boolean enable) {
        this.assertNotClosed();
        Cache<?, ?> tCache = this.getTCacheWithChecks(cacheName);
        if (tCache != null) {
            tCache.enableManagement(enable);
        }
    }

    public void enableStatistics(String cacheName, boolean enable) {
        this.assertNotClosed();
        Cache<?, ?> tCache = this.getTCacheWithChecks(cacheName);
        if (tCache != null) {
            tCache.enableStatistics(enable);
        }
    }

    private Cache<?, ?> getTCacheWithChecks(String cacheName) {
        if (this.isClosed()) {
            throw new IllegalStateException();
        }
        if (cacheName == null) {
            throw new NullPointerException();
        }
        return this.getTCache(cacheName);
    }

    public Cache<?, ?> getTCache(String cacheName) {
        for (Cache<?, ?> registeredCache : this.CacheInstances) {
            if (!registeredCache.id().equals(cacheName)) continue;
            return registeredCache;
        }
        return null;
    }

    public <K, V> javax.cache.Cache<K, V> getCache(String cacheName, Class<K> keyClass, Class<V> valueClass) {
        this.assertNotClosed();
        this.throwNpeOnNull(keyClass, "keyClass");
        this.throwNpeOnNull(valueClass, "valueClass");
        return this.getCacheInternal(cacheName, keyClass, valueClass, true);
    }

    private void throwNpeOnNull(Object obj, String message) {
        if (obj == null) {
            throw new NullPointerException(message + " must not be null");
        }
    }

    public <K, V> javax.cache.Cache<K, V> getCache(String cacheName) {
        this.assertNotClosed();
        return this.getCacheInternal(cacheName, Object.class, Object.class, false);
    }

    private <K, V> javax.cache.Cache<K, V> getCacheInternal(String cacheName, Class<?> keyClass, Class<?> valueClass, boolean isTypedCache) {
        for (Cache<?, ?> registeredCache : this.CacheInstances) {
            if (!registeredCache.id().equals(cacheName)) continue;
            TCacheJSR107<?, ?> jsr107cacheTypeless = registeredCache.jsr107cache();
            TCacheJSR107<?, ?> jsr107cache2 = registeredCache.jsr107cache();
            Configuration cc = jsr107cache2.getConfiguration(Configuration.class);
            if (keyClass != null && cc.getKeyType() != keyClass) {
                if (isTypedCache) {
                    throw new ClassCastException("Key class mismatch. cache=" + cacheName + ", requestedClass=" + keyClass.getCanonicalName() + ", cacheClass=" + cc.getKeyType());
                }
                throw new IllegalArgumentException("Key class mismatch. cache=" + cacheName + ", requestedClass=null, cacheClass=" + cc.getKeyType());
            }
            if (valueClass != null && cc.getValueType() != valueClass) {
                if (isTypedCache) {
                    throw new ClassCastException("Value class mismatch. cache=" + cacheName + ", requestedClass=" + valueClass.getCanonicalName() + ", cacheClass=" + cc.getValueType());
                }
                throw new IllegalArgumentException("Value class mismatch. cache=" + cacheName + ", requestedClass=null, cacheClass=" + cc.getValueType());
            }
            TCacheJSR107<?, ?> jsr107cache = jsr107cacheTypeless;
            return jsr107cache;
        }
        return null;
    }

    public Iterable<String> getCacheNames() {
        ArrayList<String> cacheNames = new ArrayList<String>(this.CacheInstances.size());
        for (Cache<?, ?> cache : this.CacheInstances) {
            cacheNames.add(cache.id());
        }
        return Collections.unmodifiableList(cacheNames);
    }

    public CachingProvider getCachingProvider() {
        return this.cachingProvider;
    }

    public <T> T unwrap(Class<T> clazz) {
        if (!clazz.isAssignableFrom(TCacheFactory.class)) {
            throw new IllegalArgumentException("Cannot unwrap CacheManager to unsupported Class " + clazz);
        }
        TCacheFactory thisCasted = this;
        return (T)thisCasted;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.classloader == null ? 0 : this.classloader.hashCode());
        result = 31 * result + this.uri.hashCode();
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        TCacheFactory other = (TCacheFactory)obj;
        if (this.classloader != other.classloader) {
            return false;
        }
        return this.uri.equals(other.uri);
    }
}

