/*
 * Decompiled with CFR 0.152.
 */
package com.trivago.triava.tcache;

import com.trivago.triava.annotations.ObjectSizeCalculatorIgnore;
import com.trivago.triava.tcache.AccessTimeObjectHolder;
import com.trivago.triava.tcache.Cache;
import com.trivago.triava.tcache.JamPolicy;
import com.trivago.triava.tcache.TCacheFactory;
import com.trivago.triava.tcache.core.Builder;
import com.trivago.triava.tcache.eviction.EvictionInterface;
import com.trivago.triava.tcache.eviction.HolderFreezer;
import com.trivago.triava.tcache.statistics.SlidingWindowCounter;
import com.trivago.triava.tcache.statistics.TCacheStatisticsInterface;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import javax.cache.event.EventType;

public class CacheLimit<K, V>
extends Cache<K, V> {
    private static final boolean INTERMEDIATE_NOTFULL_NOTIFICATION = false;
    private static final int FREE_PERCENTAGE = 10;
    private static final float EVICTION_SPACE_PERCENT = 15.0f;
    private static final boolean FEATURE_ExtraParEvictionSpace = false;
    private static final int EVICTION_SPACE_PER_WRITER = 2500;
    private static final int MAXIMUM_EVICTION_SPACE_FOR_WRITERS = 200000;
    private static final boolean LOG_INTERNAL_DATA = true;
    private static final boolean LOG_INTERNAL_EXTENDED_DATA = false;
    protected EvictionInterface<K, V> evictionClass = null;
    @ObjectSizeCalculatorIgnore(reason="Thread contains a classloader, which would lead to measuring the whole Heap")
    private volatile transient EvictionThread evictor = null;
    protected final AtomicLong evictionCount = new AtomicLong();
    private int counterEvictionsRounds = 0;
    private AtomicInteger counterEvictionsHalts = new AtomicInteger();
    private SlidingWindowCounter evictionRateCounter = new SlidingWindowCounter(60, 1);
    private final Object evictionNotifierDone = new Object();
    private final BlockingQueue<Boolean> evictionNotifierQ = new LinkedBlockingQueue<Boolean>(2);
    private int userDataElements;
    private int blockStartAt;
    private int evictUntilAtLeast;
    private int evictNormallyElements;

    public CacheLimit(TCacheFactory factory, Builder<K, V> builder) {
        super(factory, builder);
        if (builder.getEvictionClass() == null) {
            throw new IllegalArgumentException("evictionClass must not be null in an evicting Cache");
        }
        this.evictionClass = builder.getEvictionClass();
    }

    protected boolean isFull() {
        int size = this.objects.size();
        boolean full = size >= this.userDataElements;
        return full;
    }

    protected boolean isOverfull() {
        boolean full;
        int size = this.objects.size();
        boolean bl = full = size >= this.blockStartAt;
        if (full && CacheLimit.logInternalExtendedData()) {
            logger.info("Overfull [" + this.id() + "]. currentSize=" + size + ", blockStartAt=" + this.blockStartAt);
        }
        return full;
    }

    private static final boolean logInternalExtendedData() {
        return false;
    }

    @Override
    protected int evictionExtraSpace(Builder<K, V> builder) {
        double factor = 0.15;
        this.userDataElements = builder.getMaxElements();
        int parallelityEvictionSpace = 0;
        long normalEvictionSpace = (long)((double)this.userDataElements * factor);
        long extraEvictionSpace = Math.max(normalEvictionSpace, (long)parallelityEvictionSpace);
        long plannedSizeLong = (long)this.userDataElements + extraEvictionSpace;
        this.blockStartAt = (int)Math.min(plannedSizeLong, Integer.MAX_VALUE);
        this.evictNormallyElements = (int)((double)this.userDataElements * 10.0 / 100.0);
        this.evictNormallyElements = Math.max(1, this.evictNormallyElements);
        this.evictUntilAtLeast = this.userDataElements - this.evictNormallyElements;
        logger.info("Cache eviction tuning [" + this.id() + "]. Size=" + this.userDataElements + ", BLOCK=" + this.blockStartAt + ", evictToPos=" + this.evictUntilAtLeast + ", normal-evicting=" + this.evictNormallyElements + this.evictionConfigInfo());
        return this.blockStartAt - this.userDataElements;
    }

    protected int elementsToRemove() {
        int currentElements = this.objects.size();
        if (currentElements < this.userDataElements) {
            return 0;
        }
        int removeTargetPos = currentElements - this.evictNormallyElements;
        if (removeTargetPos > this.userDataElements) {
            removeTargetPos = this.userDataElements - this.evictNormallyElements;
        }
        if (removeTargetPos < this.evictUntilAtLeast) {
            removeTargetPos = this.evictUntilAtLeast;
        }
        int removeCount1 = currentElements - removeTargetPos;
        if (removeCount1 < 0) {
            logger.error("Trying to evict a negative number of elements. id=" + this.id() + ", currentElements=" + currentElements + ", removeCount=" + removeCount1);
        }
        return removeCount1 < 0 ? 0 : removeCount1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private EvictionThread ensureEvictionThreadIsRunning() {
        EvictionThread eThread = this.evictor;
        if (eThread != null) {
            return eThread;
        }
        CacheLimit cacheLimit = this;
        synchronized (cacheLimit) {
            if (this.evictor == null) {
                eThread = new EvictionThread("CacheEvictionThread-" + this.id());
                eThread.setPriority(1);
                eThread.setDaemon(true);
                eThread.setUncaughtExceptionHandler(eThread);
                eThread.start();
                this.evictor = eThread;
                logger.info(this.id() + " Eviction Thread started");
            } else {
                eThread = this.evictor;
            }
        }
        return eThread;
    }

    private synchronized String stopEvictor(long millis) {
        String errorMsg = null;
        EvictionThread evictorRef = this.evictor;
        if (evictorRef != null) {
            evictorRef.shutdown();
            if (millis > 0L && !this.joinSimple(evictorRef, millis, 0)) {
                errorMsg = "Shutting down Eviction Thread FAILED";
            }
        }
        return errorMsg;
    }

    @Override
    public void shutdownCustomImpl() {
        super.shutdownCustomImpl();
        String errorMsg = this.stopEvictor(100L);
        if (errorMsg != null) {
            logger.error("Shutting down Evictor for Cache " + this.id() + " FAILED. Reason: " + errorMsg);
        } else {
            logger.info("Shutting down Evictor for Cache " + this.id() + " OK");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected boolean ensureFreeCapacity() {
        if (!this.isFull()) {
            return true;
        }
        EvictionThread evictionThread = this.ensureEvictionThreadIsRunning();
        evictionThread.trigger();
        if (this.isOverfull()) {
            this.counterEvictionsHalts.incrementAndGet();
            if (this.jamPolicy == JamPolicy.DROP) {
                evictionThread = this.ensureEvictionThreadIsRunning();
                evictionThread.trigger();
                return false;
            }
        }
        while (this.isOverfull()) {
            try {
                Object object = this.evictionNotifierDone;
                synchronized (object) {
                    if (evictionThread.evictionIsRunning) {
                        this.evictionNotifierDone.wait();
                    }
                }
                evictionThread = this.ensureEvictionThreadIsRunning();
                evictionThread.trigger();
            }
            catch (InterruptedException interruptedException) {}
        }
        return true;
    }

    @Override
    protected TCacheStatisticsInterface fillCacheStatistics(TCacheStatisticsInterface cacheStatistic) {
        cacheStatistic.setEvictionCount(this.evictionCount.get());
        cacheStatistic.setEvictionRounds(this.counterEvictionsRounds);
        cacheStatistic.setEvictionHalts(this.counterEvictionsHalts.get());
        cacheStatistic.setEvictionRate(this.evictionRateCounter.getRateTotal(millisEstimator.seconds()));
        return super.fillCacheStatistics(cacheStatistic);
    }

    @Override
    protected String configToString() {
        return super.configToString() + this.evictionConfigInfo();
    }

    protected String evictionConfigInfo() {
        EvictionInterface evictionClass = this.builder.getEvictionClass();
        return ", maxElements=" + this.builder.getMaxElements() + ", eviction-class=" + (evictionClass != null ? evictionClass.getClass().getSimpleName() : "null");
    }

    class EvictionThread
    extends Thread
    implements Thread.UncaughtExceptionHandler {
        volatile boolean running;
        volatile boolean evictionIsRunning;
        Map<K, V> evictedElements;
        boolean expiryNotification;

        public EvictionThread(String name) {
            super(name);
            this.running = true;
            this.evictionIsRunning = false;
            this.evictedElements = new HashMap();
            this.expiryNotification = false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            while (this.running) {
                try {
                    this.evictionIsRunning = false;
                    CacheLimit.this.evictionNotifierQ.take();
                    CacheLimit.this.evictionNotifierQ.clear();
                    this.evictionIsRunning = true;
                    this.expiryNotification = CacheLimit.this.listeners.hasListenerFor(EventType.EXPIRED);
                    if (this.expiryNotification && this.evictedElements == null) {
                        int evictionMapSize = Math.max(CacheLimit.this.evictNormallyElements, CacheLimit.this.blockStartAt - CacheLimit.this.userDataElements);
                        this.evictedElements = new HashMap(evictionMapSize, 1.5f);
                    }
                    this.evict();
                    Object evictionMapSize = CacheLimit.this.evictionNotifierDone;
                    synchronized (evictionMapSize) {
                        this.evictionIsRunning = false;
                        CacheLimit.this.evictionNotifierDone.notifyAll();
                    }
                    if (!this.expiryNotification) continue;
                    CacheLimit.this.listeners.dispatchEvents(this.evictedElements, EventType.EXPIRED, true);
                }
                catch (InterruptedException e) {
                    Cache.logger.info(CacheLimit.this.id() + " Eviction Thread interrupted");
                }
                catch (Exception e) {
                    Cache.logger.error(CacheLimit.this.id() + " Eviction Thread error", e);
                }
                finally {
                    this.evictionIsRunning = false;
                    this.evictedElements.clear();
                }
            }
            Cache.logger.info(CacheLimit.this.id() + " Eviction Thread ended");
        }

        protected void evict() {
            CacheLimit.this.counterEvictionsRounds++;
            CacheLimit.this.evictionClass.beforeEviction();
            this.evictWithFreezer();
            CacheLimit.this.evictionClass.afterEviction();
        }

        protected void evictWithFreezer() {
            int elemsToRemovePreCheck = CacheLimit.this.elementsToRemove();
            if (elemsToRemovePreCheck <= 0) {
                return;
            }
            int i = 0;
            Set entrySet = CacheLimit.this.objects.entrySet();
            int size = entrySet.size();
            ArrayList toCheckL = new ArrayList(size);
            for (Map.Entry entry : entrySet) {
                if (i == size) break;
                Object key = entry.getKey();
                AccessTimeObjectHolder holder = (AccessTimeObjectHolder)entry.getValue();
                long frozenValue = CacheLimit.this.evictionClass.getFreezeValue(key, holder);
                HolderFreezer frozen = new HolderFreezer(key, holder, frozenValue);
                toCheckL.add(i, frozen);
                ++i;
            }
            HolderFreezer[] toCheck = toCheckL.toArray(new HolderFreezer[toCheckL.size()]);
            Arrays.sort(toCheck, CacheLimit.this.evictionClass.evictionComparator());
            int removedCount = 0;
            int elemsToRemove = CacheLimit.this.elementsToRemove();
            int notifyCountdown = 1000;
            for (HolderFreezer entryToRemove : toCheck) {
                Object key = entryToRemove.getKey();
                Object oldValue = CacheLimit.this.removeAndRelease(key);
                if (oldValue == null) continue;
                ++removedCount;
                if (this.expiryNotification) {
                    this.evictedElements.put(key, oldValue);
                }
                if (removedCount >= elemsToRemove) break;
            }
            CacheLimit.this.evictionCount.addAndGet(removedCount);
            CacheLimit.this.statisticsCalculator.incrementRemoveCount(removedCount);
            CacheLimit.this.evictionRateCounter.registerEvents(Cache.millisEstimator.seconds(), removedCount);
        }

        public void shutdown() {
            this.running = false;
            this.evictionIsRunning = false;
            this.interrupt();
        }

        @Override
        public void uncaughtException(Thread thread, Throwable throwable) {
            Cache.logger.error("EvictionThread Thread " + thread + " died because uncatched Exception", throwable);
            this.evictionIsRunning = false;
            CacheLimit.this.evictor = null;
        }

        public void trigger() {
            if (this.evictionIsRunning) {
                return;
            }
            CacheLimit.this.evictionNotifierQ.offer(Boolean.TRUE);
        }
    }
}

