/*
 * Decompiled with CFR 0.152.
 */
package com.trivago.triava.collections;

import com.trivago.triava.collections.Interner;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public class HashInterner<T>
implements Interner<T> {
    private final ConcurrentMap<T, T> interningMap;

    public HashInterner() {
        this(100);
    }

    public HashInterner(int expectedElements) {
        this.interningMap = new ConcurrentHashMap<T, T>(expectedElements);
    }

    @Override
    public T get(T value) {
        if (value == null) {
            return null;
        }
        Object sharedRefString = this.interningMap.get(value);
        if (sharedRefString != null) {
            return (T)sharedRefString;
        }
        this.interningMap.put(value, value);
        return value;
    }

    public int size() {
        return this.interningMap.size();
    }

    public String toString() {
        return "Interner " + this.hashCode() + " [" + this.size() + " elements]";
    }
}

