/*
 * Decompiled with CFR 0.152.
 */
package com.trivago.triava.util;

import com.trivago.triava.util.UnitPrefix;

public class UnitSystem {
    public static final UnitSystem SI;
    public static final UnitSystem IEC;
    public static final UnitSystem JEDEC;
    private final UnitPrefix base;
    private final UnitPrefix kilo;
    private final UnitPrefix mega;
    private final UnitPrefix giga;

    UnitSystem(UnitPrefix base, UnitPrefix kilo, UnitPrefix mega, UnitPrefix giga) {
        this.base = base;
        this.kilo = kilo;
        this.mega = mega;
        this.giga = giga;
    }

    public UnitPrefix basePrefix() {
        return this.base;
    }

    public UnitPrefix kiloPrefix() {
        return this.kilo;
    }

    public UnitPrefix megaPrefix() {
        return this.mega;
    }

    public UnitPrefix gigaPrefix() {
        return this.giga;
    }

    static {
        int SIBASE = 1000;
        UnitPrefix SI_BASE = new UnitPrefix("", "", 1);
        UnitPrefix SI_KILO = new UnitPrefix("kilo", "k", SIBASE);
        UnitPrefix SI_MEGA = new UnitPrefix("mega", "M", SIBASE * SIBASE);
        UnitPrefix SI_GIGA = new UnitPrefix("giga", "G", SIBASE * SIBASE * SIBASE);
        SI = new UnitSystem(SI_BASE, SI_KILO, SI_MEGA, SI_GIGA);
        int IECBASE = 1024;
        UnitPrefix IEC_BASE = new UnitPrefix("", "", 1);
        UnitPrefix IEC_KILO = new UnitPrefix("kibi", "Ki", IECBASE);
        UnitPrefix IEC_MEGA = new UnitPrefix("mebi", "Mi", IECBASE * IECBASE);
        UnitPrefix IEC_GIGA = new UnitPrefix("gibi", "Gi", IECBASE * IECBASE * IECBASE);
        IEC = new UnitSystem(IEC_BASE, IEC_KILO, IEC_MEGA, IEC_GIGA);
        int JEDECBASE = 1024;
        UnitPrefix JEDEC_BASE = new UnitPrefix("", "", 1);
        UnitPrefix JEDEC_KILO = new UnitPrefix("kilo", "K", JEDECBASE);
        UnitPrefix JEDEC_MEGA = new UnitPrefix("mega", "M", JEDECBASE * JEDECBASE);
        UnitPrefix JEDEC_GIGA = new UnitPrefix("giga", "G", JEDECBASE * JEDECBASE * JEDECBASE);
        JEDEC = new UnitSystem(JEDEC_BASE, JEDEC_KILO, JEDEC_MEGA, JEDEC_GIGA);
    }
}

