/*
 * Decompiled with CFR 0.152.
 */
package com.trivago.triava.time;

import com.trivago.triava.annotations.Alpha;
import com.trivago.triava.time.TimeSource;
import java.util.concurrent.TimeUnit;

@Alpha(comment="Class naming and implementation check pending")
public class OffsetTimeSource
implements TimeSource {
    final TimeSource parentTimeSource;
    final long offsetMillis;

    public OffsetTimeSource(long startTimeMillis, TimeSource parentTimeSource) {
        if (parentTimeSource == null) {
            throw new NullPointerException("parentTimeSource must not be null");
        }
        this.parentTimeSource = parentTimeSource;
        this.offsetMillis = startTimeMillis - parentTimeSource.millis();
    }

    private long getMillisFromSource() {
        return this.parentTimeSource.millis() + this.offsetMillis;
    }

    @Override
    public long time(TimeUnit tu) {
        return tu.convert(this.getMillisFromSource(), TimeUnit.MILLISECONDS);
    }

    @Override
    public long seconds() {
        return this.time(TimeUnit.SECONDS);
    }

    @Override
    public long millis() {
        return this.getMillisFromSource();
    }

    @Override
    public void shutdown() {
    }
}

