/*
 * Decompiled with CFR 0.152.
 */
package com.trivago.triava.tcache.util;

import com.trivago.triava.tcache.Cache;
import com.trivago.triava.tcache.TCacheJSR107;
import java.lang.management.ManagementFactory;
import java.util.Set;
import javax.cache.CacheException;
import javax.management.MBeanServer;
import javax.management.MBeanServerFactory;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;

public abstract class TCacheMBean {
    private static final MBeanServer mBeanServer;

    public abstract String objectNameType();

    public abstract Object getMBean(TCacheJSR107<?, ?> var1);

    public void register(Cache<?, ?> cache) {
        TCacheJSR107<?, ?> jsr107cache = cache.jsr107cache();
        ObjectName registeredObjectName = TCacheMBean.calculateObjectName(jsr107cache, this.objectNameType());
        if (TCacheMBean.isRegistered(registeredObjectName)) {
            return;
        }
        try {
            mBeanServer.registerMBean(this.getMBean(jsr107cache), registeredObjectName);
        }
        catch (Exception e) {
            throw new CacheException("Error registering cache MXBeans for CacheManager " + registeredObjectName + " . Error was " + e.getMessage(), (Throwable)e);
        }
    }

    public void unregister(Cache<?, ?> cache) {
        TCacheJSR107<?, ?> jsr107cache = cache.jsr107cache();
        ObjectName objectName = TCacheMBean.calculateObjectName(jsr107cache, this.objectNameType());
        Set<ObjectName> registeredObjectNames = mBeanServer.queryNames(objectName, null);
        for (ObjectName registeredObjectName : registeredObjectNames) {
            try {
                mBeanServer.unregisterMBean(registeredObjectName);
            }
            catch (Exception e) {
                throw new CacheException("Error unregistering object instance " + registeredObjectName + " . Error was " + e.getMessage(), (Throwable)e);
            }
        }
    }

    private static ObjectName calculateObjectName(javax.cache.Cache<?, ?> cache, String objectNameType) {
        String cacheManagerName = TCacheMBean.mbeanSafe(cache.getCacheManager().getURI().toString());
        String cacheName = TCacheMBean.mbeanSafe(cache.getName());
        try {
            return new ObjectName("javax.cache:type=Cache" + objectNameType + ",CacheManager=" + cacheManagerName + ",Cache=" + cacheName);
        }
        catch (MalformedObjectNameException e) {
            throw new CacheException("Illegal ObjectName for Management Bean. CacheManager=[" + cacheManagerName + "], Cache=[" + cacheName + "] type=[" + objectNameType + "]", (Throwable)e);
        }
    }

    static boolean isRegistered(ObjectName objectName) {
        Set<ObjectName> registeredObjectNames = mBeanServer.queryNames(objectName, null);
        return !registeredObjectNames.isEmpty();
    }

    private static String mbeanSafe(String string) {
        return string == null ? "" : string.replaceAll(",|:|=|\n", ".");
    }

    static {
        String agentId = System.getProperty("org.jsr107.tck.management.agentId");
        mBeanServer = agentId == null ? ManagementFactory.getPlatformMBeanServer() : MBeanServerFactory.createMBeanServer(agentId);
    }
}

