/*
 * Decompiled with CFR 0.152.
 */
package com.trivago.triava.tcache.statistics;

import com.trivago.triava.tcache.Cache;
import com.trivago.triava.tcache.statistics.StatisticsCalculator;
import com.trivago.triava.tcache.statistics.TCacheStatistics;
import com.trivago.triava.tcache.statistics.TCacheStatisticsMXBean;
import java.io.Serializable;

public class TCacheStatisticsBean
implements TCacheStatisticsMXBean,
Serializable {
    private static final long serialVersionUID = -2459622086065310568L;
    private final StatisticsCalculator statistics;
    private final transient Cache<?, ?> tcache;
    private final StatisticsAveragingMode averagingMode;

    public TCacheStatisticsBean(Cache<?, ?> tcache, StatisticsCalculator statisticsCalculator, StatisticsAveragingMode averagingMode) {
        this.tcache = tcache;
        this.statistics = statisticsCalculator;
        this.averagingMode = averagingMode;
    }

    public void clear() {
        this.statistics.clear();
    }

    public long getCacheHits() {
        return this.statistics.getHitCount();
    }

    public float getCacheHitPercentage() {
        if (this.averagingMode == StatisticsAveragingMode.PER_MINUTE) {
            TCacheStatistics statistics2 = this.tcache.statistics();
            return statistics2.getHitRatio();
        }
        return this.safeRate(this.getCacheHits(), this.getCacheGets(), 0);
    }

    private float safeRate(long divident, long divisor, int defaultValue) {
        if (divisor == 0L) {
            return defaultValue;
        }
        return 100.0f * (float)divident / (float)divisor;
    }

    public long getCacheMisses() {
        return this.statistics.getMissCount();
    }

    public float getCacheMissPercentage() {
        if (this.averagingMode == StatisticsAveragingMode.PER_MINUTE) {
            if (this.getCacheGets() == 0L) {
                return 0.0f;
            }
            TCacheStatistics statistics2 = this.tcache.statistics();
            return 100.0f - statistics2.getHitRatio();
        }
        return this.safeRate(this.getCacheMisses(), this.getCacheGets(), 0);
    }

    public long getCacheGets() {
        return this.statistics.getHitCount() + this.statistics.getMissCount();
    }

    public long getCachePuts() {
        return this.statistics.getPutCount();
    }

    public long getCacheRemovals() {
        return this.statistics.getRemoveCount();
    }

    public long getCacheEvictions() {
        TCacheStatistics statistics2 = this.tcache.statistics();
        return statistics2.getEvictionCount() + statistics2.getDropCount();
    }

    public float getAverageGetTime() {
        return 0.0f;
    }

    public float getAveragePutTime() {
        return 0.0f;
    }

    public float getAverageRemoveTime() {
        return 0.0f;
    }

    @Override
    public int getSize() {
        return this.tcache.size();
    }

    public static enum StatisticsAveragingMode {
        JSR107,
        PER_MINUTE;

    }
}

