/*
 * Decompiled with CFR 0.152.
 */
package com.trivago.triava.tcache.expiry;

import com.trivago.triava.tcache.expiry.TCacheExpiryPolicy;
import javax.cache.expiry.Duration;
import javax.cache.expiry.ExpiryPolicy;

public class UntouchedExpiryPolicy
implements TCacheExpiryPolicy {
    final long expiryForCreation;
    final long expiryForAccess;
    final long expiryForUpdate;

    public UntouchedExpiryPolicy(ExpiryPolicy expiryPolicy) {
        this.expiryForCreation = this.convertToMillis(expiryPolicy.getExpiryForCreation(), 0L);
        this.expiryForAccess = this.convertToMillis(expiryPolicy.getExpiryForAccess(), -1L);
        this.expiryForUpdate = this.convertToMillis(expiryPolicy.getExpiryForUpdate(), -1L);
    }

    long convertToMillis(Duration expiryDuration, long defaultValue) {
        return expiryDuration != null ? expiryDuration.getAdjustedTime(0L) : defaultValue;
    }

    @Override
    public long getExpiryForCreation() {
        return this.expiryForCreation;
    }

    @Override
    public long getExpiryForAccess() {
        return this.expiryForAccess;
    }

    @Override
    public long getExpiryForUpdate() {
        return this.expiryForUpdate;
    }
}

