/*
 * Decompiled with CFR 0.152.
 */
package com.trivago.triava.tcache.event;

import com.trivago.triava.tcache.Cache;
import com.trivago.triava.tcache.event.CacheEventManager;
import com.trivago.triava.tcache.event.DispatchMode;
import com.trivago.triava.tcache.event.ListenerCacheEventManager;
import com.trivago.triava.tcache.event.TCacheEntryEvent;
import com.trivago.triava.tcache.event.TCacheEntryEventCollection;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import javax.cache.configuration.CacheEntryListenerConfiguration;
import javax.cache.configuration.Factory;
import javax.cache.event.CacheEntryCreatedListener;
import javax.cache.event.CacheEntryEvent;
import javax.cache.event.CacheEntryEventFilter;
import javax.cache.event.CacheEntryExpiredListener;
import javax.cache.event.CacheEntryListener;
import javax.cache.event.CacheEntryRemovedListener;
import javax.cache.event.CacheEntryUpdatedListener;
import javax.cache.event.EventType;

final class ListenerEntry<K, V> {
    private final CacheEntryListenerConfiguration<K, V> config;
    private CacheEntryEventFilter<? super K, ? super V> filter = null;
    private CacheEntryListener<? super K, ? super V> listener = null;
    private final Cache<K, V> tcache;
    private final CacheEventManager<K, V> eventManager;
    private final DispatchMode dispatchMode;
    private final BlockingQueue<TCacheEntryEventCollection<K, V>> dispatchQueue;
    private DispatchRunnable dispatchThread = null;

    ListenerEntry(CacheEntryListenerConfiguration<K, V> config, Cache<K, V> tcache, DispatchMode dispatchMode) {
        this.config = config;
        this.tcache = tcache;
        this.dispatchMode = dispatchMode;
        ListenerCacheEventManager em = null;
        Factory listenerFactory = config.getCacheEntryListenerFactory();
        if (listenerFactory != null) {
            this.listener = (CacheEntryListener)listenerFactory.create();
            if (this.listener != null) {
                Factory filterFactory = config.getCacheEntryEventFilterFactory();
                if (filterFactory != null) {
                    this.filter = (CacheEntryEventFilter)filterFactory.create();
                }
                em = new ListenerCacheEventManager();
            }
        }
        this.eventManager = em;
        this.dispatchQueue = new ArrayBlockingQueue<TCacheEntryEventCollection<K, V>>(1024);
        this.dispatchThread = this.ensureListenerThreadIsRunning();
    }

    CacheEntryListenerConfiguration<K, V> getConfig() {
        return this.config;
    }

    void dispatch(Iterable<TCacheEntryEvent<K, V>> events, EventType eventType, boolean forceAsync) {
        if (this.eventManager == null) {
            return;
        }
        CacheEntryListener<? super K, ? super V> listenerRef = this.listener;
        int batchSize = 256;
        int i = 0;
        boolean needsSend = false;
        ArrayList<Object> interestingEvents = new ArrayList<CacheEntryEvent<K, V>>(batchSize);
        for (TCacheEntryEvent<K, V> event : events) {
            if (!this.interested(event)) continue;
            interestingEvents.add(event);
            needsSend = true;
            if (i++ != batchSize) continue;
            this.scheduleEvents(interestingEvents, listenerRef, eventType, forceAsync);
            needsSend = false;
            interestingEvents = new ArrayList(batchSize);
            i = 0;
        }
        if (needsSend) {
            this.scheduleEvents(interestingEvents, listenerRef, eventType, forceAsync);
        }
    }

    void dispatch(TCacheEntryEvent<K, V> event) {
        if (this.eventManager == null) {
            return;
        }
        if (!this.interested(event)) {
            return;
        }
        CacheEntryListener<? super K, ? super V> listenerRef = this.listener;
        if (!this.dispatchMode.isAsync()) {
            this.sendEvent(event, listenerRef);
        } else {
            try {
                this.dispatchQueue.put(this.createSingleEvent(event));
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        }
    }

    private void scheduleEvents(List<CacheEntryEvent<? extends K, ? extends V>> events, CacheEntryListener<K, V> listener, EventType eventType, boolean forceAsync) {
        if (this.eventManager == null) {
            return;
        }
        TCacheEntryEventCollection<? extends K, ? extends V> eventColl = new TCacheEntryEventCollection<K, V>(events, eventType);
        if (!forceAsync && !this.dispatchMode.isAsync()) {
            this.sendEvents(eventColl, listener);
        } else {
            try {
                this.dispatchQueue.put(eventColl);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        }
    }

    private void sendEvent(CacheEntryEvent<? extends K, ? extends V> event, CacheEntryListener<K, V> listener) {
        this.sendEvents(this.createSingleEvent(event), listener);
    }

    private void sendEvents(TCacheEntryEventCollection<K, V> eventColl, CacheEntryListener<K, V> listener) {
        EventType eventType = eventColl.eventType();
        switch (eventType) {
            case CREATED: {
                if (!(listener instanceof CacheEntryCreatedListener)) break;
                this.eventManager.created((CacheEntryCreatedListener)listener, eventColl);
                break;
            }
            case EXPIRED: {
                if (!(listener instanceof CacheEntryExpiredListener)) break;
                this.eventManager.expired((CacheEntryExpiredListener)listener, eventColl);
                break;
            }
            case UPDATED: {
                if (!(listener instanceof CacheEntryUpdatedListener)) break;
                this.eventManager.updated((CacheEntryUpdatedListener)listener, eventColl);
                break;
            }
            case REMOVED: {
                if (!(listener instanceof CacheEntryRemovedListener)) break;
                this.eventManager.removed((CacheEntryRemovedListener)listener, eventColl);
                break;
            }
        }
    }

    private TCacheEntryEventCollection<K, V> createSingleEvent(TCacheEntryEvent<K, V> event) {
        ArrayList events = new ArrayList();
        events.add(event);
        TCacheEntryEventCollection coll = new TCacheEntryEventCollection(events, event.getEventType());
        return coll;
    }

    private boolean interested(CacheEntryEvent<? extends K, ? extends V> event) {
        return this.filter == null ? true : this.filter.evaluate(event);
    }

    void shutdown() {
        DispatchRunnable runnable = this.dispatchThread;
        if (runnable != null) {
            runnable.shutdown();
        }
    }

    public int hashCode() {
        return this.getConfig().hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListenerEntry)) {
            return false;
        }
        return this.getConfig() == ((ListenerEntry)obj).getConfig();
    }

    private DispatchRunnable ensureListenerThreadIsRunning() {
        this.dispatchThread = new DispatchRunnable(this.tcache.id());
        this.dispatchThread.start();
        return this.dispatchThread;
    }

    private TCacheEntryEventCollection<K, V> createSingleEvent(CacheEntryEvent<? extends K, ? extends V> event) {
        ArrayList list = new ArrayList();
        list.add(event);
        TCacheEntryEventCollection coll = new TCacheEntryEventCollection(list, event.getEventType());
        return coll;
    }

    boolean isListeningFor(EventType eventType) {
        switch (eventType) {
            case CREATED: {
                return this.listener instanceof CacheEntryCreatedListener;
            }
            case EXPIRED: {
                return this.listener instanceof CacheEntryExpiredListener;
            }
            case REMOVED: {
                return this.listener instanceof CacheEntryRemovedListener;
            }
            case UPDATED: {
                return this.listener instanceof CacheEntryUpdatedListener;
            }
        }
        return false;
    }

    private class DispatchRunnable
    extends Thread
    implements Runnable {
        private volatile boolean running;

        DispatchRunnable(String cacheId) {
            super("tCache-Notifier:" + cacheId);
            this.running = true;
            this.setDaemon(true);
        }

        @Override
        public void run() {
            CacheEntryListener listenerRef = ListenerEntry.this.listener;
            while (this.running) {
                try {
                    TCacheEntryEventCollection eventColl = (TCacheEntryEventCollection)ListenerEntry.this.dispatchQueue.take();
                    ListenerEntry.this.sendEvents(eventColl, listenerRef);
                }
                catch (InterruptedException interruptedException) {
                }
                catch (Exception exception) {}
            }
        }

        public void shutdown() {
            this.running = false;
            DispatchRunnable thread = ListenerEntry.this.dispatchThread;
            if (thread != null) {
                thread.interrupt();
                ListenerEntry.this.dispatchThread = null;
            }
        }
    }
}

