/*
 * Decompiled with CFR 0.152.
 */
package com.trivago.triava.tcache.event;

import com.trivago.triava.tcache.Cache;
import com.trivago.triava.tcache.TCacheJSR107;
import com.trivago.triava.tcache.core.Builder;
import com.trivago.triava.tcache.event.DispatchMode;
import com.trivago.triava.tcache.event.ListenerEntry;
import com.trivago.triava.tcache.event.TCacheEntryEvent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import javax.cache.configuration.CacheEntryListenerConfiguration;
import javax.cache.event.EventType;

public class ListenerCollection<K, V> {
    private final Set<ListenerEntry<K, V>> listeners = Collections.newSetFromMap(new ConcurrentHashMap());
    private final Builder<K, V> builder;
    private final Cache<K, V> tcache;
    private final TCacheJSR107<K, V> jsr107cache;
    private volatile short listenerPresentMask = 0;

    public ListenerCollection(Cache<K, V> tcache, Builder<K, V> builder) {
        this.builder = builder;
        this.tcache = tcache;
        this.jsr107cache = tcache.jsr107cache();
        Iterator<CacheEntryListenerConfiguration<K, V>> it = builder.getCacheEntryListenerConfigurations().iterator();
        while (it.hasNext()) {
            this.enableCacheEntryListener(it.next());
        }
    }

    public synchronized void deregisterCacheEntryListener(CacheEntryListenerConfiguration<K, V> listenerConfiguration) {
        this.throwISEwhenClosed();
        Iterator<ListenerEntry<K, V>> it = this.listeners.iterator();
        while (it.hasNext()) {
            ListenerEntry<K, V> listenerEntry = it.next();
            if (!listenerConfiguration.equals(listenerEntry.getConfig())) continue;
            listenerEntry.shutdown();
            it.remove();
            this.builder.removeCacheEntryListenerConfiguration(listenerConfiguration);
            break;
        }
        this.rebuildListenerPresent();
    }

    private void rebuildListenerPresent() {
        short listenerPresentXnew = 0;
        for (ListenerEntry<K, V> listener : this.listeners) {
            for (EventType eventType : EventType.values()) {
                if (!listener.isListeningFor(eventType)) continue;
                listenerPresentXnew = (short)(listenerPresentXnew | 1 << eventType.ordinal());
            }
        }
        this.listenerPresentMask = listenerPresentXnew;
    }

    public synchronized void registerCacheEntryListener(CacheEntryListenerConfiguration<K, V> listenerConfiguration) {
        this.throwISEwhenClosed();
        boolean added = this.enableCacheEntryListener(listenerConfiguration);
        if (!added) {
            throw new IllegalArgumentException("Cache entry listener may not be added twice to " + this.tcache.id() + ": " + listenerConfiguration);
        }
        this.builder.addCacheEntryListenerConfiguration(listenerConfiguration);
    }

    private synchronized boolean enableCacheEntryListener(CacheEntryListenerConfiguration<K, V> listenerConfiguration) {
        DispatchMode dispatchMode = listenerConfiguration.isSynchronous() ? DispatchMode.SYNC : DispatchMode.ASYNC_TIMED;
        ListenerEntry<K, V> newListener = new ListenerEntry<K, V>(listenerConfiguration, this.tcache, dispatchMode);
        boolean added = this.listeners.add(newListener);
        for (EventType eventType : EventType.values()) {
            if (!newListener.isListeningFor(eventType)) continue;
            this.listenerPresentMask = (short)(this.listenerPresentMask | 1 << eventType.ordinal());
        }
        return added;
    }

    public void dispatchEvent(EventType eventType, K key, V value) {
        if (this.hasListenerFor(eventType)) {
            this.dispatchEventToListeners(new TCacheEntryEvent<K, V>(this.jsr107cache, eventType, key, value));
        }
    }

    public void dispatchEvent(EventType eventType, K key, V value, V oldValue) {
        if (this.hasListenerFor(eventType)) {
            this.dispatchEventToListeners(new TCacheEntryEvent<K, V>(this.jsr107cache, eventType, key, value, oldValue));
        }
    }

    public void dispatchEvents(Map<K, V> entries, EventType eventType, boolean forceAsync) {
        if (!this.hasListenerFor(eventType)) {
            return;
        }
        ArrayList<TCacheEntryEvent<K, V>> events = new ArrayList<TCacheEntryEvent<K, V>>(entries.size());
        for (Map.Entry<K, V> entry : entries.entrySet()) {
            K key = entry.getKey();
            V value = entry.getValue();
            TCacheEntryEvent<K, V> event = new TCacheEntryEvent<K, V>(this.jsr107cache, eventType, key, value);
            events.add(event);
        }
        this.dispatchEventsToListeners(events, eventType, forceAsync);
    }

    private void dispatchEventToListeners(TCacheEntryEvent<K, V> event) {
        for (ListenerEntry<K, V> listener : this.listeners) {
            listener.dispatch(event);
        }
    }

    private void dispatchEventsToListeners(Iterable<TCacheEntryEvent<K, V>> events, EventType eventType, boolean forceAsync) {
        if (!this.hasListenerFor(eventType)) {
            return;
        }
        for (ListenerEntry<K, V> listener : this.listeners) {
            listener.dispatch(events, eventType, forceAsync);
        }
    }

    public boolean hasListenerFor(EventType eventType) {
        int present = this.listenerPresentMask & 1 << eventType.ordinal();
        return present != 0;
    }

    public int size() {
        return this.listeners.size();
    }

    private void throwISEwhenClosed() {
        if (this.tcache.isClosed()) {
            throw new IllegalStateException("Cache already closed: " + this.tcache.id());
        }
    }

    public void shutdown() {
        for (ListenerEntry<K, V> listener : this.listeners) {
            listener.shutdown();
        }
    }
}

