/*
 * Decompiled with CFR 0.152.
 */
package com.trivago.triava.tcache.core;

import com.trivago.triava.tcache.TCacheFactory;
import java.net.URI;
import java.util.Collections;
import java.util.Iterator;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import javax.cache.CacheManager;
import javax.cache.configuration.OptionalFeature;
import javax.cache.spi.CachingProvider;

public class TCacheProvider
implements CachingProvider {
    Set<CacheManager> cacheManagers = Collections.newSetFromMap(new ConcurrentHashMap());
    Object cacheManagersLock = new Object();

    public ClassLoader getDefaultClassLoader() {
        return TCacheFactory.standardFactory().getClassLoader();
    }

    public URI getDefaultURI() {
        return TCacheFactory.standardFactory().getURI();
    }

    public Properties getDefaultProperties() {
        return TCacheFactory.standardFactory().getProperties();
    }

    public CacheManager getCacheManager() {
        return this.getCacheManager(this.getDefaultURI(), this.getDefaultClassLoader(), null);
    }

    public CacheManager getCacheManager(URI uri, ClassLoader classLoader) {
        return this.getCacheManager(uri, classLoader, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CacheManager getCacheManager(URI uri, ClassLoader classLoader, Properties properties) {
        if (classLoader == null) {
            classLoader = this.getDefaultClassLoader();
        }
        if (uri == null) {
            uri = this.getDefaultURI();
        }
        Object object = this.cacheManagersLock;
        synchronized (object) {
            CacheManager cacheManager = this.findCacheManager(uri, classLoader);
            if (cacheManager == null) {
                cacheManager = properties == null ? new TCacheFactory(uri, classLoader, this) : new TCacheFactory(uri, classLoader, properties, this);
                this.cacheManagers.add(cacheManager);
            }
            return cacheManager;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CacheManager findCacheManager(URI uri, ClassLoader classLoader) {
        Object object = this.cacheManagersLock;
        synchronized (object) {
            for (CacheManager cacheManager : this.cacheManagers) {
                if (!cacheManager.getURI().equals(uri) || !cacheManager.getClassLoader().equals(classLoader)) continue;
                return cacheManager;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        Object object = this.cacheManagersLock;
        synchronized (object) {
            Iterator<CacheManager> it = this.cacheManagers.iterator();
            while (it.hasNext()) {
                CacheManager cacheManager = it.next();
                cacheManager.close();
                it.remove();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close(ClassLoader classLoader) {
        Object object = this.cacheManagersLock;
        synchronized (object) {
            Iterator<CacheManager> it = this.cacheManagers.iterator();
            while (it.hasNext()) {
                CacheManager cacheManager = it.next();
                if (!cacheManager.getClassLoader().equals(classLoader)) continue;
                cacheManager.close();
                it.remove();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close(URI uri, ClassLoader classLoader) {
        Object object = this.cacheManagersLock;
        synchronized (object) {
            CacheManager cacheManager = this.findCacheManager(uri, classLoader);
            if (cacheManager != null) {
                cacheManager.close();
                this.cacheManagers.remove(cacheManager);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeCacheManager0(CacheManager cacheManager) {
        Object object = this.cacheManagersLock;
        synchronized (object) {
            this.cacheManagers.remove(cacheManager);
        }
    }

    public boolean isSupported(OptionalFeature optionalFeature) {
        return optionalFeature == OptionalFeature.STORE_BY_REFERENCE;
    }
}

